/*!\file Spc.h
 * \brief: header file for spc object
 */

#ifndef _SPC_H_
#define _SPC_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
class DataSet;
/*}}}*/

class Spc: public Object{

	private: 
		int	sid; /*! id, to track it*/
		int	nodeid; /*!node id*/
		int dof; /*!component*/
		double value; /*value*/

	public:

		Spc();
		Spc(int sid,int nodeid, int dof,double value);
		~Spc();

		void   Echo();
		void   DeepEcho();
		void   Marshall(char** pmarshalled_dataset);
		int    MarshallSize();
		void   Demarshall(char** pmarshalled_dataset);
		int    Enum();
		int    Id(); 
		int    MyRank();
		void   DistributeNumDofs(int* numdofspernode,int analysis_type);
		int    GetNodeId();
		int    GetDof();
		double GetValue();
		Object* copy();
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}


};

#endif  /* _SPC_H_ */
