/*!\file UpdateInputsFromSolutionx
 * \brief: update datasets using  parameter inputs
 */

#include "./UpdateInputsFromSolutionx.h"
#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void UpdateInputsFromSolutionx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,Vec solution, int analysis_type, int sub_analysis_type){

	double* serial_solution=NULL;

	/*Serialize solution, so that elements can index into it on every CPU: */
	VecToMPISerial(&serial_solution,solution);

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	
	/*Elements drive the update: */
	elements->UpdateInputsFromSolution(serial_solution,analysis_type,sub_analysis_type);

	/*Free ressources:*/
	xfree((void**)&serial_solution);

}
