/*!\file ProcessParamsx
 * \brief: process parameters using partitioning vector. 
 * Go through all parameters in the 'parameters' dataset. For each parameter that holds a doublevec (ie, a double* vector synchronized across 
 * the MPI ring of a cluster), partition the vector so that the new node partitioning decided in ModelProcessor is applied. Otherwise, 
 * parameters coming directly from Matlab would be serially partitioned, which means could not be recognized by each individual node or element. 
 * The partition needs to be the parallel partitionting.
 */

#include "./ProcessParamsx.h"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../DataSet/DataSet.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void ProcessParamsx( Parameters* parameters, Vec  part){

	
	double* partition=NULL;
	Param*  param=NULL;

	/*diverse: */
	int numberofvertices;
	int i,j,k;
	int ndof;
	int param_type;

	/*processing of parameters: */
	double* parameter=NULL;
	double* new_parameter=NULL;

	/*Some parameters needed: */
	parameters->FindParam(&numberofvertices,NumberOfVerticesEnum);

	/*serialize partition vector: */
	if(part)VecToMPISerial(&partition,part);

	for(i=0;i<parameters->Size();i++){

		param_type=parameters->GetEnum(i);

		if(param_type==ParamEnum){

			Param* param=(Param*)parameters->GetObjectByOffset(i);

			if (param->GetType()==DOUBLEVEC){

				ndof=param->GetNdof();

				if (ndof!=0){ /*ok, we are dealing with a parameter that needs to be repartitioned, for ndof degrees of freedom: */

					new_parameter=(double*)xcalloc(numberofvertices*ndof,sizeof(double));
					param->GetParameterValue(&parameter);

					for(j=0;j<ndof;j++){

						for(k=0;k<numberofvertices;k++){
						
							new_parameter[(int)(ndof*partition[k]+j)]=parameter[ndof*k+j];

						}

					}
				
					
					/*Now, replace old parameter with new parameter: */
					param->SetDoubleVec(new_parameter,ndof*numberofvertices,ndof);

					/*Free ressources: */
					xfree((void**)&new_parameter);
					xfree((void**)&parameter);

				}
			}
		}
	}
	xfree((void**)&partition);

}
