/*
 * \file Parameters.c
 * \brief: implementation of the Parameters class, derived from DataSet class
 */

/*Headers: {{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <vector>
#include <functional>
#include <algorithm>
#include <iostream>

#include "./DataSet.h"
#include "../shared/shared.h"
#include "../include/macros.h"
#include "../EnumDefinitions/EnumDefinitions.h"

using namespace std;
/*}}}*/
/*Parameters: {{{1*/


/*Object constructors and destructor*/
/*FUNCTION Parameters::Parameters(){{{2*/
Parameters::Parameters(){
	return;
}
/*}}}*/
/*FUNCTION Parameters::Parameters(int in_enum){{{2*/
Parameters::Parameters(int in_enum): DataSet(in_enum){
	//do nothing;
	return;
}
/*}}}*/
/*FUNCTION Parameters::~Parameters(){{{2*/
Parameters::~Parameters(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION Parameters::FindParam(double* pscalar, int enum_type){{{2*/
int   Parameters::FindParam(double* pscalar, int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Find param type objects: */
		if((*object)->Enum()==ParamEnum){

			/*Ok, this object is a parameter, recover it and ask which name it has: */
			param=(Param*)(*object);

			if(param->EnumType()==enum_type){
				/*Ok, this is the one! Recover the value of this parameter: */
				param->GetParameterValue(pscalar);
				found=1;
				break;
			}
		}
	}
	return found;
}
/*}}}*/
/*FUNCTION Parameters::FindParam(int* pinteger,int enum_type){{{2*/
int   Parameters::FindParam(int* pinteger,int enum_type){
	
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Find param type objects: */
		if((*object)->Enum()==ParamEnum){

			/*Ok, this object is a parameter, recover it and ask which name it has: */
			param=(Param*)(*object);

			if(param->EnumType()==enum_type){
				/*Ok, this is the one! Recover the value of this parameter: */
				param->GetParameterValue(pinteger);
				found=1;
				break;
			}
		}
	}
	return found;
}
/*}}}*/
/*FUNCTION Parameters::FindParam(char** pstring,int enum_type){{{2*/
int   Parameters::FindParam(char** pstring,int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Find param type objects: */
		if((*object)->Enum()==ParamEnum){

			/*Ok, this object is a parameter, recover it and ask which name it has: */
			param=(Param*)(*object);

			if(param->EnumType()==enum_type){
				/*Ok, this is the one! Recover the value of this parameter: */
				param->GetParameterValue(pstring);
				found=1;
				break;
			}
		}
	}
	return found;

}
/*}}}*/
/*FUNCTION Parameters::FindParam(char*** pstringarray,int* pM,int enum_type){{{2*/
int   Parameters::FindParam(char*** pstringarray,int* pM,int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Find param type objects: */
		if((*object)->Enum()==ParamEnum){

			/*Ok, this object is a parameter, recover it and ask which name it has: */
			param=(Param*)(*object);

			if(param->EnumType()==enum_type){
				/*Ok, this is the one! Recover the value of this parameter: */
				param->GetParameterValue(pstringarray,pM);
				found=1;
				break;
			}
		}
	}
	return found;

}
/*}}}*/
/*FUNCTION Parameters::FindParam(double** pdoublearray,int* pM,int enum_type){{{2*/
int   Parameters::FindParam(double** pdoublearray,int* pM, int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Find param type objects: */
		if((*object)->Enum()==ParamEnum){

			/*Ok, this object is a parameter, recover it and ask which name it has: */
			param=(Param*)(*object);

			if(param->EnumType()==enum_type){
				/*Ok, this is the one! Recover the value of this parameter: */
				param->GetParameterValue(pdoublearray,pM);
				found=1;
				break;
			}
		}
	}
	return found;

}
/*}}}*/
/*FUNCTION Parameters::FindParam(double** pdoublearray,int* pM, int* pN,int enum_type){{{2*/
int   Parameters::FindParam(double** pdoublearray,int* pM, int* pN,int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Find param type objects: */
		if((*object)->Enum()==ParamEnum){

			/*Ok, this object is a parameter, recover it and ask which name it has: */
			param=(Param*)(*object);

			if(param->EnumType()==enum_type){
				/*Ok, this is the one! Recover the value of this parameter: */
				param->GetParameterValue(pdoublearray,pM,pN);
				found=1;
				break;
			}
		}
	}
	return found;

}
/*}}}*/
/*FUNCTION Parameters::FindParam(Vec* pvec,int enum_type){{{2*/
int   Parameters::FindParam(Vec* pvec,int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Find param type objects: */
		if((*object)->Enum()==ParamEnum){

			/*Ok, this object is a parameter, recover it and ask which name it has: */
			param=(Param*)(*object);

			if(param->EnumType()==enum_type){
				/*Ok, this is the one! Recover the value of this parameter: */
				param->GetParameterValue(pvec);
				found=1;
				break;
			}
		}
	}
	return found;

}
/*}}}*/
/*FUNCTION Parameters::FindParamMat* pmat,int enum_type){{{2*/
int   Parameters::FindParam(Mat* pmat,int enum_type){
	
	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */
	
	vector<Object*>::iterator object;
	Param* param=NULL;

	int found=0;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Find param type objects: */
		if((*object)->Enum()==ParamEnum){

			/*Ok, this object is a parameter, recover it and ask which name it has: */
			param=(Param*)(*object);

			if(param->EnumType()==enum_type){
				/*Ok, this is the one! Recover the value of this parameter: */
				param->GetParameterValue(pmat);
				found=1;
				break;
			}
		}
	}
	return found;

}
/*}}}*/
/*FUNCTION Parameters::FindParamObject{{{2*/
Object* Parameters::FindParamObject(int enum_type){

	/*Go through a dataset, and find a Param* object 
	 *which parameter name is "name" : */

	vector<Object*>::iterator object;
	Param* param=NULL;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Find param type objects: */
		if((*object)->Enum()==ParamEnum){

			/*Ok, this object is a parameter, recover it and ask which name it has: */
			param=(Param*)(*object);

			if(param->EnumType()==enum_type){
				/*Ok, this is the one! Return the object: */
				return (*object);
			}
		}
	}
	return NULL;
}
/*}}}*/

/*Object functions*/


/*}}}*/
