function  m=CreateFemModel(md,solutiontype)
%CREATEFEMMODEL - create a finite element model structure
%
%   returns a structure that holds the elements, the grids, the loads, the contraints
%   and other parameters needed to build the stiffness matrix and load vector
%
%   Usage:
%      m=CreateFemModel(md,solutiontype)

global gridset

disp(['   creating fem model for solution ' solutiontype]);

%First, build elements,grids,loads, etc ... for horizontal model
[elements,grids,loads,constraints,materials,part,tpart]=ModelProcessor(md,solutiontype);
	
%generate degrees of freedom
grids=Dof(grids); 
	
%add constraints to grids. Create yg vector of constraint values for the entire g set.
[grids yg]=SpcGrids(grids,constraints);

%build Rmg for multi point constraints
Rmg=MpcGrids(grids,constraints);

%generate grid sets and reduce yg to ys from g-set to s-set.
BuildGridSets(grids,constraints); ys=Reducevector_g(yg);

%buile Gmn
Gmn=Normalizeconstraints(Rmg);

%recover dof number
dof=gridset.fsize;

%setup some parameters to be passed to the core solution
params=SetupParams(md);

m.elements=elements;
m.grids=grids;
m.loads=loads;
m.constraints=constraints;
m.materials=materials;
m.part=part;
m.tpart=tpart;
m.ys=ys;
m.gridset=gridset;
m.dof=dof;
m.params=params;
m.Gmn=Gmn;
