/*! \file Beam.h 
 *  \brief: header file for beam object
 */

#ifndef _BEAM_H_
#define _BEAM_H_

/*Headers:*/
/*{{{1*/

#include "./Element.h"
class Hook;
class Parameters;
class Inputs;
class IoModel;

#include "../../shared/Exceptions/exceptions.h"
#include "../../include/macros.h"
/*}}}*/

class Beam: public Element{

	public:

		/*ids:*/
		int id;

		Hook hnodes;  //hook to 2 nodes
		Hook hmatice; //hook to 1 matice
		Hook hmatpar; //hook to 1 matpar
		
		Parameters* parameters; //pointer to solution parameters
		Inputs* inputs;
	

		/*constructors, destructors: {{{1*/
		Beam();
		Beam(int beam_id,int* beam_node_ids, int beam_matice_id, int beam_matpar_id);
		Beam(int beam_id,Hook* beam_hnodes, Hook* beam_hmatice, Hook* beam_hmatpar, Parameters* beam_parameters, Inputs* beam_inputs);
		Beam(int beam_id,int i, IoModel* iomodel);
		~Beam();
		/*}}}*/
		/*object management: {{{1*/
		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   Id(); 
		int   MyRank();
		void  Configure(DataSet* loads,DataSet* nodes,DataSet* materials,Parameters* parameters);
		Object* copy();
		void  SetClone(int* minranks);

		/*}}}*/
		/*numerics: {{{1*/
		void  CreateKMatrix(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg,  int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  GetDofList1(int* doflist);
		void  CreateKMatrixDiagnosticHutter(Mat Kgg,int analysis_type,int sub_analysis_type);
		void  GetParameterValue(double* pp, double* plist, double* gauss_l1l2l3);
		void  CreatePVectorDiagnosticHutter(Vec pg,int analysis_type,int sub_analysis_type);
		void* GetMatPar();

		void  ComputeBasalStress(Vec sigma_b,int analysis_type,int sub_analysis_type);
		void  ComputePressure(Vec p_g,int analysis_type,int sub_analysis_type);
		void  ComputeStrainRate(Vec eps,int analysis_type,int sub_analysis_type);
		void  GetNodes(void** vpnodes);
		/*}}}*/
		/*not implemented: {{{1*/
		bool  GetShelf();
		bool  GetOnBed();
		void  GetBedList(double*);
		void  GetThicknessList(double* thickness_list);
		void  Du(Vec, int,int);
		void  Gradj(Vec,  int, int,char*);
		void  GradjDrag(Vec,  int,int );
		void  GradjB(Vec,  int,int );
		double Misfit(int,int);
		double SurfaceArea(int,int);
		double CostFunction(int,int);
		void  GetNodalFunctions(double* l1l2, double gauss_coord);
		void  GetParameterValue(double* pvalue, double* value_list,double gauss_coord);
		void  GetJacobianDeterminant(double* pJdet,double* z_list, double gauss_coord);
		double MassFlux(double* segment,double* ug);
		void AddInput(double value, int enum_type){ISSMERROR("not supporte yet!");}
		/*}}}*/

};
#endif  /* _BEAM_H */
