/*!\file UpdateInputsFromVectorx
 * \brief: update datasets using  parameter inputs
 */

#include "./UpdateInputsFromVectorx.h"
#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

int UpdateInputsFromVectorx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,double* vector, int NameEnum, int TypeEnum){

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Update elements, nodes, loads and materials from inputs: */
	elements->UpdateInputsFromVector(serial_solution,analysis_type,sub_analysis_type);
	nodes->UpdateInputsFromVector(serial_solution,analysis_type,sub_analysis_type);
	vertices->UpdateInputsFromVector(serial_solution,analysis_type,sub_analysis_type);
	loads->UpdateInputsFromVector(serial_solution,analysis_type,sub_analysis_type);
	materials->UpdateInputsFromVector(serial_solution,analysis_type,sub_analysis_type);
	parameters->UpdateInputsFromVector(serial_solution,analysis_type,sub_analysis_type);

	return noerr;

}
