/*!\file UpdateInputsFromSolutionx
 * \brief: update datasets using  parameter inputs
 */

#include "./UpdateInputsFromSolutionx.h"
#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

int UpdateInputsFromSolutionx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,Vec solution, int analysis_type, int sub_analysis_type){

	int noerr=1;
	int i;

	int  found=0;
	extern int num_procs;
	extern int my_rank;
	double* serial_solution=NULL;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Serialize solution, so that elements can index into it on every CPU: */
	VecToMPISerial(&serial_solution,solution);

	/*Update elements, nodes, loads and materials from inputs: */
	elements->UpdateInputsFromSolution(serial_solution,analysis_type,sub_analysis_type);
	nodes->UpdateInputsFromSolution(serial_solution,analysis_type,sub_analysis_type);
	vertices->UpdateInputsFromSolution(serial_solution,analysis_type,sub_analysis_type);
	loads->UpdateInputsFromSolution(serial_solution,analysis_type,sub_analysis_type);
	materials->UpdateInputsFromSolution(serial_solution,analysis_type,sub_analysis_type);
	parameters->UpdateInputsFromSolution(serial_solution,analysis_type,sub_analysis_type);

	/*Free ressources:*/
	xfree((void**)&serial_solution);

	return noerr;

}
