/*
 * CreateElementsNodesAndMaterialsBalancedthickness2.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../include/typedefs.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateElementsNodesAndMaterialsBalancedthickness2(DataSet** pelements,DataSet** pnodes, DataSet** pvertices,DataSet** pmaterials, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i,j;
	int vertex_index;
	int node_index;

	/*DataSets: */
	DataSet* elements  = NULL;
	DataSet* nodes = NULL;
	DataSet* vertices = NULL;
	DataSet* materials = NULL;

	/*First create the elements, nodes and material properties: */
	elements  = new DataSet(ElementsEnum);
	nodes     = new DataSet(NodesEnum);
	vertices  = new DataSet(VerticesEnum);
	materials = new DataSet(MaterialsEnum);

	/*Partition elements and vertices and nodes: */
	Partitioning(&iomodel->my_elements, &iomodel->my_vertices, &iomodel->my_nodes, &iomodel->my_bordervertices, iomodel, iomodel_handle);

	/*elements created vary if we are dealing with a 2d mesh, or a 3d mesh: */
	/*2d mesh: */
	if (strcmp(iomodel->meshtype,"2d")==0){

		/*Fetch data needed: */
		IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
		IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
		IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
		IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
		IoModelFetchData(&iomodel->elementoniceshelf,NULL,NULL,iomodel_handle,"elementoniceshelf");
		IoModelFetchData(&iomodel->elementonwater,NULL,NULL,iomodel_handle,"elementonwater");
		IoModelFetchData(&iomodel->vx,NULL,NULL,iomodel_handle,"vx");
		IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"vy");
		IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"melting_rate");
		IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"accumulation_rate");
		
		for (i=0;i<iomodel->numberofelements;i++){

			if(iomodel->my_elements[i]){

				/*Create and add tria element to elements dataset: */
				elements->AddObject(new Tria(i+1,i,iomodel));

				/*Create and add material property to materials dataset: */
				materials->AddObject(new Matice(i+1,i,iomodel,3));
			}
		}//for (i=0;i<numberofelements;i++)
	
		/*Free data : */
		xfree((void**)&iomodel->thickness);
		xfree((void**)&iomodel->surface);
		xfree((void**)&iomodel->bed);
		xfree((void**)&iomodel->elementoniceshelf);
		xfree((void**)&iomodel->elementonwater);
		xfree((void**)&iomodel->vx);
		xfree((void**)&iomodel->vy);
		xfree((void**)&iomodel->melting_rate);
		xfree((void**)&iomodel->accumulation_rate);

	}
	else{ //	if (strcmp(meshtype,"2d")==0)
		ISSMERROR("not implemented yet");
	} //if (strcmp(meshtype,"2d")==0)

	/*Add new constrant material property tgo materials, at the end: */
	materials->AddObject(new Matpar(iomodel->numberofelements+1,iomodel));

	/*Create nodes and vertices: */
	IoModelFetchData(&iomodel->x,NULL,NULL,iomodel_handle,"x");
	IoModelFetchData(&iomodel->y,NULL,NULL,iomodel_handle,"y");
	IoModelFetchData(&iomodel->z,NULL,NULL,iomodel_handle,"z");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->gridonsurface,NULL,NULL,iomodel_handle,"gridonsurface");
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");
	IoModelFetchData(&iomodel->gridonicesheet,NULL,NULL,iomodel_handle,"gridonicesheet");
	IoModelFetchData(&iomodel->gridoniceshelf,NULL,NULL,iomodel_handle,"gridoniceshelf");
	if (strcmp(iomodel->meshtype,"3d")==0){
		IoModelFetchData(&iomodel->deadgrids,NULL,NULL,iomodel_handle,"deadgrids");
		IoModelFetchData(&iomodel->uppernodes,NULL,NULL,iomodel_handle,"uppergrids");
	}

	/*Build Vertices dataset*/
	for (i=0;i<iomodel->numberofvertices;i++){

		/*vertices and nodes (same number, as we are running continuous galerkin formulation: */
		if(iomodel->my_vertices[i]){

			/*Add vertex to vertices dataset: */
			vertices->AddObject(new Vertex(i+1,i,iomodel));

		}
	}

	/*Build Nodes dataset -> 3 for each element (Discontinuous Galerkin)*/
	for (i=0;i<iomodel->numberofelements;i++){
		for (j=0;j<3;j++){

			if(iomodel->my_nodes[3*i+j]){ 

				//Get index of the vertex on which the current node is located
				vertex_index=(int)*(iomodel->elements+3*i+j)-1; //(Matlab to C indexing)
				ISSMASSERT(vertex_index>=0 && vertex_index<iomodel->numberofvertices);

				//Compute Node index (id-1)
				node_index=3*i+j;

				/*Add node to nodes dataset: */
				nodes->AddObject(new Node(i+1,vertex_index,node_index,iomodel));

			}
		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->deadgrids);
	xfree((void**)&iomodel->x);
	xfree((void**)&iomodel->y);
	xfree((void**)&iomodel->z);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->gridonsurface);
	xfree((void**)&iomodel->gridonhutter);
	xfree((void**)&iomodel->uppernodes);
	xfree((void**)&iomodel->gridonicesheet);
	xfree((void**)&iomodel->gridoniceshelf);
	xfree((void**)&iomodel->elements);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	elements->Presort();
	nodes->Presort();
	vertices->Presort();
	materials->Presort();

	cleanup_and_return:

	/*Assign output pointer: */
	*pelements=elements;
	*pnodes=nodes;
	*pvertices=vertices;
	*pmaterials=materials;
}
