/*\file UpdateInputsFromVector.c
*\brief: update elements properties using an input  vector
*/

#include "./UpdateInputsFromVector.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

/*diverse: */
int   noerr=1;

/*input datasets: */
DataSet* elements=NULL;
DataSet* nodes=NULL;
DataSet* vertices=NULL;
DataSet* loads=NULL;
DataSet* materials=NULL;
DataSet* parameters=NULL;
double*  vector=NULL;
int      NameEnum;
int      TypeEnum;

/*Boot module: */
MODULEBOOT();

/*checks on arguments on the matlab side: */
CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateInputsFromVectorUsage);

/*Input datasets: */
FetchData(&elements,ELEMENTSIN);
FetchData(&nodes,NODESIN);
FetchData(&vertices,VERTICESIN);
FetchData(&loads,LOADSIN);
FetchData(&materials,MATERIALSIN);
FetchParams(&parameters,PARAMETERSIN);
FetchData(&vector,VECTOR);
FetchData(&NameEnum,NAME);
FetchData(&TypeEnum,TYPE);

/*Check that type is one of Constant, Vertex or Element: */
if ((TypeEnum!=ConstantEnum) && (TypeEnum!=VertexEnum) && (TypeEnum!=ElementEnum)){
	ISSMERROR("%s%s%s\n","Type of input can only be a constant, a vertex or an element vector.  Right now, you input a ",EnumAsString(TypeEnum)," type data for input update");
}

/*!Generate internal degree of freedom numbers: */
UpdateInputsFromVectorx(elements,nodes,vertices,loads, materials,parameters,vector,NameEnum,TypeEnum);

/*write output datasets: */
WriteData(ELEMENTS,elements);
WriteData(NODES,nodes);
WriteData(VERTICES,vertices);
WriteData(LOADS,loads);
WriteData(MATERIALS,materials);
WriteParams(PARAMETERS,parameters);

/*Free ressources: */
delete elements;
delete nodes;
delete vertices;
delete loads;
delete materials;
delete parameters;
xfree((void**)&vector);

/*end module: */
MODULEEND();
}

void UpdateInputsFromVectorUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements] = %s(elements,nodes,vertices,loads,materials,parameters,solution,analysis_type,sub_analysis_type);\n",__FUNCT__);
	_printf_("\n");
}
