/*!\file: CreateParameters.cpp
 * \brief general driver for creating parameters dataset
 */ 

#include "../DataSet/DataSet.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../MeshPartitionx/MeshPartitionx.h"

void CreateParameters(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	int i;
	
	Parameters* parameters = NULL;
	Param*   param = NULL;
	int      count=0;
	int      numberofdofspernode;
	int      dim;
	char**   parameteroutput=NULL;
	char*    descriptor=NULL;
	char*    tag=NULL;
	#ifdef _SERIAL_
		mxArray* pfield=NULL;
		mxArray* pfield2=NULL;
	#endif

	/*Initialize dataset: */
	parameters   = new Parameters(ParametersEnum);

	//outputfilename
	parameters->AddObject(new StringParam(OutputFileNameEnum,iomodel->outputfilename));
 
	//dimension 2d or 3d:
	if (strcmp(iomodel->meshtype,"2d")==0)dim=2;
	else dim=3;

	parameters->AddObject(new DoubleParam(DimEnum,dim);
	
	//elements types
	parameters->AddObject(new DoubleParam(IsHutterEnum,iomodel->ishutter));
	parameters->AddObject(new DoubleParam(IsMacAyealPattynEnum,iomodel->ismacayealpattyn));
	parameters->AddObject(new DoubleParam(IsStokesEnum,iomodel->isstokes));
	parameters->AddObject(new DoubleParam(VerboseEnum,iomodel->verbose));

	/*eps_res: */
	parameters->AddObject(new DoubleParam(EpsResEnum,iomodel->eps_res));

	/*eps_rel: */
	parameters->AddObject(new DoubleParam(EpsRelEnum,iomodel->eps_rel));

	/*eps_abs: */
	parameters->AddObject(new DoubleParam(EpsAbsEnum,iomodel->eps_abs));

	/*max_nonlinear_iterations: */
	parameters->AddObject(new DoubleParam(MaxNonlinearIterationsEnum,iomodel->max_nonlinear_iterations));

	/*yts: */
	parameters->AddObject(new DoubleParam(YtsEnum,iomodel->yts));

	/*dt: */
	parameters->AddObject(new DoubleParam(DtEnum,iomodel->dt));

	/*ndt: */
	parameters->AddObject(new DoubleParam(NdtEnum,iomodel->ndt));

	/*penalty_offset: */
	parameters->AddObject(new DoubleParam(PenaltyOffsetEnum,iomodel->penalty_offset));

	/*sparsity: */
	parameters->AddObject(new DoubleParam(SparsityEnum,iomodel->sparsity));

	/*lowmem: */
	parameters->AddObject(new DoubleParam(LowmemEnum,iomodel->lowmem));

	/*connectivity: */
	parameters->AddObject(new DoubleParam(ConnectivityEnum,iomodel->connectivity));

	/*beta: */
	parameters->AddObject(new DoubleParam(BetaEnum,iomodel->beta));

	/*meltingpoint: */
	parameters->AddObject(new DoubleParam(BetaEnum,iomodel->beta));
	count++;
	param= new Param(count,"meltingpoint",DOUBLE);
	param->SetDouble(iomodel->meltingpoint);
	parameters->AddObject(param);

	/*latentheat: */
	count++;
	param= new Param(count,"latentheat",DOUBLE);
	param->SetDouble(iomodel->latentheat);
	parameters->AddObject(param);

	/*heatcapacity: */
	count++;
	param= new Param(count,"heatcapacity",DOUBLE);
	param->SetDouble(iomodel->heatcapacity);
	parameters->AddObject(param);

	/*artdiff: */
	count++;
	param= new Param(count,"artdiff",DOUBLE);
	param->SetDouble(iomodel->artdiff);
	parameters->AddObject(param);
	
	/*penalty_melting: */
	count++;
	param= new Param(count,"penalty_melting",DOUBLE);
	param->SetDouble(iomodel->penalty_melting);
	parameters->AddObject(param);

	/*min_thermal_constraints: */
	count++;
	param= new Param(count,"min_thermal_constraints",DOUBLE);
	param->SetDouble(iomodel->min_thermal_constraints);
	parameters->AddObject(param);

	/*min_mechanical_constraints: */
	count++;
	param= new Param(count,"min_mechanical_constraints",DOUBLE);
	param->SetDouble(iomodel->min_mechanical_constraints);
	parameters->AddObject(param);

	/*stabilize_constraints: */
	count++;
	param= new Param(count,"stabilize_constraints",DOUBLE);
	param->SetDouble(iomodel->stabilize_constraints);
	parameters->AddObject(param);

	/*stokesreconditioning: */
	count++;
	param= new Param(count,"stokesreconditioning",DOUBLE);
	param->SetDouble(iomodel->stokesreconditioning);
	parameters->AddObject(param);

	/*viscosity_overshoot: */
	count++;
	param= new Param(count,"viscosity_overshoot",DOUBLE);
	param->SetDouble(iomodel->viscosity_overshoot);
	parameters->AddObject(param);

	/*waitonlock: */
	count++;
	param= new Param(count,"waitonlock",DOUBLE);
	param->SetDouble(iomodel->waitonlock);
	parameters->AddObject(param);

	/*solverstring: */
	count++;
	param= new Param(count,"solverstring",STRING);
	param->SetString(iomodel->solverstring);
	parameters->AddObject(param);

	/*plot: */
	count++;
	param= new Param(count,"plot",DOUBLE);
	param->SetDouble(iomodel->plot);
	parameters->AddObject(param);

	/*numberofvertices: */
	count++;
	param= new Param(count,"numberofvertices",DOUBLE);
	param->SetDouble(iomodel->numberofvertices);
	parameters->AddObject(param);

	/*numberofnodes: */
	count++;
	param= new Param(count,"numberofnodes",DOUBLE);
	if (
				iomodel->analysis_type==Prognostic2AnalysisEnum ||
				iomodel->analysis_type==Balancedthickness2AnalysisEnum
				)
	 param->SetDouble(3*iomodel->numberofelements);
	else param->SetDouble(iomodel->numberofvertices);
	parameters->AddObject(param);

	/*numberofelements: */
	count++;
	param= new Param(count,"numberofelements",DOUBLE);
	param->SetDouble(iomodel->numberofelements);
	parameters->AddObject(param);

	/*Deal with numberofdofspernode: */
	DistributeNumDofs(&numberofdofspernode,iomodel->analysis_type,iomodel->sub_analysis_type);
	count++;
	param= new Param(count,"numberofdofspernode",DOUBLE);
	param->SetDouble(numberofdofspernode);
	parameters->AddObject(param);

	/*numrifts: */
	IoModelFetchData(&iomodel->riftinfo,&iomodel->numrifts,NULL,iomodel_handle,"riftinfo");
	count++;
	param= new Param(count,"numrifts",DOUBLE);
	param->SetDouble(iomodel->numrifts);
	parameters->AddObject(param);
	xfree((void**)&iomodel->riftinfo); 
	
	/*epsvel: */
	count++;
	param= new Param(count,"epsvel",DOUBLE);
	param->SetDouble(iomodel->epsvel);
	parameters->AddObject(param);

	/*parameteroutput: */
	count++;
	param= new Param(count,"numoutput",DOUBLE);
	param->SetDouble(iomodel->numoutput);
	parameters->AddObject(param);

	if(iomodel->numoutput){
		parameteroutput=(char**)xmalloc(iomodel->numoutput*sizeof(char*));

		#ifdef _SERIAL_
		pfield=mxGetField(iomodel_handle,0,"parameteroutput");
		for(i=0;i<iomodel->numoutput;i++){
			pfield2=mxGetCell(pfield,i);
			FetchData(&descriptor,pfield2);
			parameteroutput[i]=descriptor;
		}
		#else
		tag=(char*)xmalloc((strlen("parameteroutput_i")+1)*sizeof(char));
		for(i=0;i<iomodel->numoutput;i++){
			sprintf(tag,"%s%i","parameteroutput_",i);
			IoModelFetchData(&descriptor,iomodel_handle,tag);
			parameteroutput[i]=descriptor;
		}
		#endif

		/*Ok, we have all the parameter output  descriptors. Build a parameter with it: */
		count++;
		param= new Param(count,"parameteroutput",STRINGARRAY);
		param->SetStringArray(parameteroutput,iomodel->numoutput);
		parameters->AddObject(param);
	}

	/*All our datasets are already ordered by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	parameters->Presort();

	/*Free data: */
	xfree((void**)&tag);
	for(i=0;i<iomodel->numoutput;i++){
		char* descriptor=parameteroutput[i];
		xfree((void**)&descriptor);
	}
	xfree((void**)&parameteroutput);

	/*Assign output pointer: */
	*pparameters=parameters;
}
