/*!\file:  Input.h
 * \brief abstract class for Input object
 */ 


#ifndef _INPUT_H_
#define _INPUT_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
class Node;
#include "../Node.h"
/*}}}*/

class Input: public Object{

	public: 
		
		virtual        ~Input(){};
		virtual int    Enum()=0; //object Enum
		virtual int    EnumType()=0; //type of input (vx,vy?)

		/*methods:{{{1*/
		virtual void GetParameterValue(bool* pvalue)=0;
		virtual void GetParameterValue(int* pvalue)=0;
		virtual void GetParameterValue(double* pvalue)=0;
		virtual void GetParameterValue(double* pvalue,Node* node)=0;
		virtual void GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord)=0;
		virtual void GetParameterValue(double* pvalue,double* gauss)=0;
		virtual void GetParameterValue(double* pvalue,double* gauss,double defaultvalue)=0;
		
		virtual void GetParameterValues(double* values,double* gauss_pointers, int numgauss)=0;
	
		virtual void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss)=0;
		virtual void GetStrainRate(double* epsilon, Input* yinput, double* xyz_list, double* gauss)=0;
		virtual void GetStrainRateStokes(double* epsilon,Input* yinput, Input* zinput, double* xyz_list, double* gauss)=0;

		/*}}}*/

};
#endif
