/*! \file BoolParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _BOOLPARAM_H_
#define _BOOLPARAM_H_

/*Headers:*/
/*{{{1*/
#include "./Param.h"
#include "../../include/types.h"
#include "../../shared/shared.h"
#include "../../include/typedefs.h"
#include "../../include/macros.h"
/*}}}*/

class BoolParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		IssmBool value;

	public:
		/*constructors, destructors: {{{1*/
		BoolParam();
		BoolParam(int enum_type,IssmBool value);
		~BoolParam();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		/*}}}*/
		/*Param methods: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){*pbool=value;}
		void  GetParameterValue(int* pinteger){ISSMERROR("Bool param cannot return an integer");}
		void  GetParameterValue(double* pdouble){ISSMERROR("Bool param cannot return a double");}
		void  GetParameterValue(char** pstring){ISSMERROR("Bool param cannot return a string");}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("Bool param cannot return a string arrayl");}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("Bool param cannot return a double array");}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("Bool param cannot return a double array");}
		void  GetParameterValue(Vec* pvec){ISSMERROR("Bool param cannot return a Vec");}
		void  GetParameterValue(Mat* pmat){ISSMERROR("Bool param cannot return a Mat");}
		char* GetParameterName(void);
		void  SetMatlabField(mxArray* dataref);
		/*}}}*/
};
#endif  /* _BOOLPARAM_H */
