/*!\file TriaVertexInput.c
 * \brief: implementation of the TriaVertexInput object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/typedefs.h"
#include "../../include/macros.h"

/*Object constructors and destructor*/
/*FUNCTION TriaVertexInput::TriaVertexInput(){{{1*/
TriaVertexInput::TriaVertexInput(){
	return;
}
/*}}}*/
/*FUNCTION TriaVertexInput::TriaVertexInput(double* values){{{1*/
TriaVertexInput::TriaVertexInput(int in_enum_type,double* in_values){

	enum_type=in_enum_type;
	values[0]=in_values[0];
	values[1]=in_values[1];
	values[2]=in_values[2];
}
/*}}}*/
/*FUNCTION TriaVertexInput::~TriaVertexInput(){{{1*/
TriaVertexInput::~TriaVertexInput(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION TriaVertexInput::copy{{{1*/
Object* TriaVertexInput::copy() {
	
	return new TriaVertexInput(this->enum_type,this->values);

}
/*}}}*/
/*FUNCTION TriaVertexInput::DeepEcho{{{1*/
void TriaVertexInput::DeepEcho(void){

	printf("TriaVertexInput:\n");
	printf("   enum: %i\n",this->enum_type);
	printf("   %g|%g|%g\n",this->values[0],this->values[1],this->values[2]);
}
/*}}}*/
/*FUNCTION TriaVertexInput::Demarshall{{{1*/
void  TriaVertexInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&values,marshalled_dataset,sizeof(values));marshalled_dataset+=sizeof(values);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION TriaVertexInput::Echo {{{1*/
void TriaVertexInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION TriaVertexInput::Enum{{{1*/
int TriaVertexInput::Enum(void){

	return TriaVertexInputEnum;

}
/*}}}*/
/*FUNCTION TriaVertexInput::EnumType{{{1*/
int TriaVertexInput::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION TriaVertexInput::Id{{{1*/
int    TriaVertexInput::Id(void){ return -1; }
/*}}}*/
/*FUNCTION TriaVertexInput::Marshall{{{1*/
void  TriaVertexInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of TriaVertexInput: */
	enum_value=TriaVertexInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall TriaVertexInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&values,sizeof(values));marshalled_dataset+=sizeof(values);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION TriaVertexInput::MarshallSize{{{1*/
int   TriaVertexInput::MarshallSize(){
	
	return sizeof(values)+
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION TriaVertexInput::MyRank{{{1*/
int    TriaVertexInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/

/*Object functions*/
/*FUNCTION TriaVertexInput::GetParameterValue(bool* pvalue) {{{1*/
void TriaVertexInput::GetParameterValue(bool* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION TriaVertexInput::GetParameterValue(int* pvalue){{{1*/
void TriaVertexInput::GetParameterValue(int* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION TriaVertexInput::GetParameterValue(double* pvalue){{{1*/
void TriaVertexInput::GetParameterValue(double* pvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION TriaVertexInput::GetParameterValue(double* pvalue,Node* node){{{1*/
void TriaVertexInput::GetParameterValue(double* pvalue,Node* node){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION TriaVertexInput::GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord){{{1*/
void TriaVertexInput::GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION TriaVertexInput::GetParameterValue(double* pvalue,double* gauss){{{1*/
void TriaVertexInput::GetParameterValue(double* pvalue,double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION TriaVertexInput::GetParameterValue(double* pvalue,double* gauss,double defaultvalue){{{1*/
void TriaVertexInput::GetParameterValue(double* pvalue,double* gauss,double defaultvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION TriaVertexInput::GetParameterValues(double* values,double* gauss_pointers, int numgauss){{{1*/
void TriaVertexInput::GetParameterValues(double* values,double* gauss_pointers, int numgauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION TriaVertexInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){{{1*/
void TriaVertexInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION TriaVertexInput::GetStrainRate(double* epsilon,Input* yinput, double* xyz_list, double* gauss){{{1*/
void TriaVertexInput::GetStrainRate(double* epsilon,Input* yinput,double* xyz_list, double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION TriaVertexInput::GetStrainRateStokes(double* epsilon,Input* yinput, Input* zinput, double* xyz_list, double* gauss){{{1*/
void TriaVertexInput::GetStrainRateStokes(double* epsilon,Input* yinput,Input* zinput, double* xyz_list, double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
