/*! \file DoubleInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _DOUBLEINPUT_H_
#define _DOUBLEINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
#include "../../include/types.h"
/*}}}*/

class DoubleInput: public Input{

	private: 
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		IssmDouble value;

	public:

		/*constructors, destructors: {{{1*/
		DoubleInput();
		DoubleInput(int enum_type,IssmDouble value);
		~DoubleInput();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();

		/*}}}*/
		/*numerics: {{{1*/
		void GetParameterValue(bool* pvalue);
		void GetParameterValue(int* pvalue);
		void GetParameterValue(double* pvalue);
		void GetParameterValue(double* pvalue,Node* node);
		void GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord);
		void GetParameterValue(double* pvalue,double* gauss);
		void GetParameterValue(double* pvalue,double* gauss,double defaultvalue);
		
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss);
	
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss);
		void GetStrainRate(double* epsilon,Input* yinput, double* xyz_list, double* gauss);
		void GetStrainRateStokes(double* epsilon,Input* yinput, Input* zinput, double* xyz_list, double* gauss);
		/*}}}*/

};
#endif  /* _DOUBLEINPUT_H */
