/*!\file:  OptArgs.h
 * \brief place holder for optimization function arguments
 */ 

#ifndef _OPTARGS_H_
#define _OPTARGS_H_

#ifdef _SERIAL_

#include "mex.h"

struct OptArgs{

	char* function_name;
	mxArray* models;
	mxArray* inputs;
	mxArray* param_g;
	mxArray* grad_g;
	mxArray* n;
	mxArray* analysis_type;
	mxArray* sub_analysis_type;

};
#else
class Model;
struct OptArgs{
	Model* model;
	double* param_g;
	double* grad_g;
	int n;
};
#endif

#endif
