#!/bin/bash
#Synchronize StringFromEnum.cpp from EnumDefinition.h

#first remove existing files
rm StringFromEnum.cpp
rm StringFromEnum.h

echo "Synchronizing StringFromEnum..."
#Get all lines of EnumDefinitions2.h which hold Enum, | remove all comas | add line number in the first column > put everything in file temp
cat EnumDefinitions.h | grep "Enum," |sed -e "s/,//g" | awk '{ printf "%s %s\n", NR, $0 }' > temp

#Build File StringFromEnum.h
cat <<END > StringFromEnum.h
/*
* \file StringFromEnum.h:
* \brief: output string associated with enum
*/

#ifndef _STRINGFROMENUM_
#define _STRINGFROMENUM_

char* StringFromEnum(int en);

#endif
END

#Build File StringFromEnum.cpp
cat <<END > StringFromEnum.cpp
/*
* \file StringFromEnum.cpp:
* \brief: output string associated with enum
*/

#include "./StringFromEnum.h"

char* StringFromEnum(int en){

	switch(en){

END

#get number of lines in temp
NUMBEROFLINES=$(wc -l temp | awk '{printf("%s",$1);}');

# go through the lines of temp
for i in `seq 1 1 $NUMBEROFLINES`; do

	#Get name and enum of the line i
	NAME=$(cat temp | grep "^[ ]*$i " | awk '{printf("%s",$2);}' | sed -e "s/Enum//g");
	ENUM=$i;
	#offset Enum by one (Enum begins with 0 and not 1!)
	let ENUM=$ENUM-1

	#print info
	if [ $i -lt 10 ]
	then
		printf "\r                                                                      "
		printf "\r  $i/$NUMBEROFLINES Adding "$NAME"..."
	else
		if [ $i -lt 100 ]
		then
			printf "\r                                                                      "
			printf "\r $i/$NUMBEROFLINES Adding "$NAME"..."
		else
			printf "\r                                                                      "
			printf "\r$i/$NUMBEROFLINES Adding "$NAME"..."
		fi
	fi

	#Add corresponding lines
	cat <<END >> StringFromEnum.cpp
		case $ENUM :
			return "$NAME";
END
done

#end of file
cat <<END >> StringFromEnum.cpp
		default :
			ISSMERROR("Enum %i not found",en);
	}
}
END

#clean up
rm temp

#print info
printf "\r                                                                      "
printf "\rdone!\n"
