/*!\file:  OptFunc.cpp
 * \brief: "C" code wrapper to matlab objectivefunctionC call
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"

#ifdef _SERIAL_
#include "mex.h"
double OptFunc(double scalar, OptArgs* optargs){
	
	/*output: */
	double J;

	mxArray*   inputs[7];
	mxArray*   psearch_scalar=NULL;
	mxArray*   mxJ=NULL;

	psearch_scalar=mxCreateDoubleScalar(scalar);
	inputs[0]=psearch_scalar;
	inputs[1]=optargs->models;
	inputs[3]=optargs->param_g;
	inputs[4]=optargs->grad_g;
	inputs[5]=optargs->n;
	inputs[6]=optargs->analysis_type;
	inputs[7]=optargs->sub_analysis_type;

	mexCallMATLAB( 1, &mxJ, 8, (mxArray**)inputs, optargs->function_name);

	/*extract misfit from mxArray*/
	J=mxGetScalar(mxJ);

	return J;
}
#else
double OptFunc(double scalar, OptArgs* optargs){
	ISSMERROR(" not implemented yet");
}
#endif
