/*! \file StringParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _STRINGPARAM_H_
#define _STRINGPARAM_H_

/*Headers:*/
/*{{{1*/
#include "./Param.h"
#include "../include/types.h"
#include "../shared/shared.h"
#include "../include/typedefs.h"
#include "../include/macros.h"
/*}}}*/

class StringParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		char* value;

	public:
		/*constructors, destructors: {{{1*/
		StringParam();
		StringParam(int enum_type,char* value);
		~StringParam();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		/*}}}*/
		/*Param methods: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("String param cannot return a bool");}
		void  GetParameterValue(int* pinteger){ISSMERROR("String param cannot return an integer");}
		void  GetParameterValue(double* pdouble){ISSMERROR("String param cannot return a double");}
		void  GetParameterValue(char** pstring);
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("String param cannot return a string arrayl");}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("String param cannot return a double array");}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("String param cannot return a double array");}
		void  GetParameterValue(Vec* pvec){ISSMERROR("String param cannot return a Vec");}
		void  GetParameterValue(Mat* pmat){ISSMERROR("String param cannot return a Mat");}
		char* GetParameterName(void);
		void  SetMatlabField(mxArray* dataref);
		/*}}}*/
};
#endif  /* _STRINGPARAM_H */
