/*! \file StringArrayParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _STRINGARRAYPARAM_H_
#define _STRINGARRAYPARAM_H_

/*Headers:*/
/*{{{1*/
#include "./Param.h"
#include "../include/types.h"
#include "../shared/shared.h"
#include "../include/typedefs.h"
#include "../include/macros.h"
/*}}}*/

class StringArrayParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int      enum_type;
		char**   value;
		int      numstrings;


	public:
		/*constructors, destructors: {{{1*/
		StringArrayParam();
		StringArrayParam(int enum_type,char** values, int numstrings);
		~StringArrayParam();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		/*}}}*/
		/*Param methods: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("StringArray param cannot return a bool");}
		void  GetParameterValue(int* pinteger){ISSMERROR("StringArray param cannot return an integer");}
		void  GetParameterValue(double* pdouble){ISSMERROR("StringArray param cannot return a double");}
		void  GetParameterValue(char** pstring){ISSMERROR("StringArray param cannot return a string");}
		void  GetParameterValue(char*** pstringarray,int* pM);
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("StringArray param cannot return a double array");}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("StringArray param cannot return a double array");}
		void  GetParameterValue(Vec* pvec){ISSMERROR("StringArray param cannot return a Vec");}
		void  GetParameterValue(Mat* pmat){ISSMERROR("StringArray param cannot return a Mat");}
		char* GetParameterName(void);
		void  SetMatlabField(mxArray* dataref);
		/*}}}*/
};
#endif  /* _STRINGARRAYPARAM_H */
