/*! \file PetscMatParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _PETSCMATPARAM_H_
#define _PETSCMATPARAM_H_

/*Headers:*/
/*{{{1*/
#include "./Param.h"
#include "../include/types.h"
#include "../shared/shared.h"
#include "../include/typedefs.h"
#include "../include/macros.h"
/*}}}*/

class PetscMatParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		Mat value;

	public:
		/*constructors, destructors: {{{1*/
		PetscMatParam();
		PetscMatParam(int enum_type,Mat value);
		~PetscMatParam();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		/*}}}*/
		/*Param methods: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("PetscMat param cannot return a bool");}
		void  GetParameterValue(int* pinteger){ISSMERROR("PetscMat param cannot return an integer");}
		void  GetParameterValue(double* pdouble){ISSMERROR("PetscMat param cannot return a double");}
		void  GetParameterValue(char** pstring){ISSMERROR("PetscMat param cannot return a string");}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("PetscMat param cannot return a string arrayl");}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("PetscMat param cannot return a double array");}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("PetscMat param cannot return a double array");}
		void  GetParameterValue(Vec* pvec){ISSMERROR("PetscMat param cannot return a vec");}
		char* GetParameterName(void);
		void  SetMatlabField(mxArray* dataref);
		/*}}}*/
};
#endif  /* _PETSCMATPARAM_H */
