/*! \file DoubleMatParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _DOUBLEMATPARAM_H_
#define _DOUBLEMATPARAM_H_

/*Headers:*/
/*{{{1*/
#include "./Param.h"
#include "../include/types.h"
#include "../shared/shared.h"
#include "../include/typedefs.h"
#include "../include/macros.h"
/*}}}*/

class DoubleMatParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		IssmDouble* value;
		int M;
		int N;

	public:
		/*constructors, destructors: {{{1*/
		DoubleMatParam();
		DoubleMatParam(int enum_type,IssmDouble* value,int M,int N);
		~DoubleMatParam();
		/*}}}*/
		/*Object methods: {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		/*}}}*/
		/*Param methods: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("DoubleMat param cannot return a bool");}
		void  GetParameterValue(int* pinteger){ISSMERROR("DoubleMat param cannot return an integer");}
		void  GetParameterValue(double* pdouble){ISSMERROR("DoubleMat param cannot return a double");}
		void  GetParameterValue(char** pstring){ISSMERROR("DoubleMat param cannot return a string");}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("DoubleMat param cannot return a string arrayl");}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("DoubleMat param cannot return a double array");}
		void  GetParameterValue(Vec* pvec){ISSMERROR("DoubleMat param cannot return a Vec");}
		void  GetParameterValue(Mat* pmat){ISSMERROR("DoubleMat param cannot return a Mat");}
		char* GetParameterName(void);
		void  SetMatlabField(mxArray* dataref);
		/*}}}*/
};
#endif  /* _DOUBLEMATPARAM_H */
