/*\file io.h
 *\brief: I/O for ISSM
 */

#ifndef IO_H_
#define IO_H_

#include "../objects/NodeSets.h"
#include "../objects/DofVec.h"
#include "../objects/BamgMesh.h"
#include "../objects/BamgGeom.h"
#include "../DataSet/DataSet.h"
#include "../include/types.h"

class DataSet;

FILE* pfopen(char* filename,char* format);
void  pfclose(FILE* fid,char* filename);

#ifdef _SERIAL_

void WriteData(mxArray** pdataref,DataSet* dataset);
void WriteData(mxArray** pdataref,Mat matrix);
void WriteData(mxArray** pdataref,double* matrix, int M,int N);
void WriteData(mxArray** pdataref,Vec vector);
void WriteData(mxArray** pdataref,double* vector, int M);
void WriteData(mxArray** pdataref,int integer);
void WriteData(mxArray** pdataref,double scalar);
void WriteData(mxArray** pdataref,char* string);
void WriteData(mxArray** pdataref,DofVec* vector);
void WriteData(mxArray** pdataref,BamgMesh* bm);
void WriteData(mxArray** pdataref,BamgGeom* bg);

void WriteNodeSets(DataHandle* pdataref,NodeSets* nodesets);
void WriteParams(DataHandle* pdataref,Parameters* parameters);

void FetchData(DataSet** pdataset,const mxArray* dataref);
void FetchData(double** pmatrix,int* pM,int *pN,const mxArray* dataref);
void FetchData(Mat* pmatrix,const mxArray* dataref);
void FetchData(double** pvector,int* pM,const mxArray* dataref);
void FetchData(Vec* pvector,const mxArray* dataref);
void FetchData(char** pstring,const mxArray* dataref);
void FetchData(double* pscalar,const mxArray* dataref);
void FetchData(int* pinteger,const mxArray* dataref);


void IoModelFetchData(DataSet** pdataset,ConstDataHandle model_handle,char* data_name);
void IoModelFetchData(double** pmatrix,int* pM,int *pN,ConstDataHandle model_handle,char* data_name);
void IoModelFetchData(Mat* pmatrix,ConstDataHandle model_handle,char* data_name);
void IoModelFetchData(double** pvector,int* pM,ConstDataHandle model_handle,char* data_name);
void IoModelFetchData(Vec* pvector,ConstDataHandle model_handle,char* data_name);
void IoModelFetchData(char** pstring,ConstDataHandle model_handle,char* data_name);
void IoModelFetchData(double* pscalar,ConstDataHandle model_handle,char* data_name);
void IoModelFetchData(int* pinteger,ConstDataHandle model_handle,char* data_name);

void FetchNodeSets(NodeSets** pnodesets,ConstDataHandle dataref);
void FetchParams(DataSet** pparameters, DataHandle dataref);

#endif





#ifdef _PARALLEL_
void FetchData(double** pmatrix, int* pM,int* pN,FILE* fid);
void FetchData(char** pstring,FILE* fid);
void FetchData(double* pscalar,FILE* fid);
void FetchData(int* pinteger,FILE* fid);


FILE* SetFilePointerToData(ConstDataHandle model_handle,char* data_name);
void  IoModelFetchData(double** pmatrix,int* pM,int* pN,ConstDataHandle model_handle,char* data_name);
void  IoModelFetchData(char** pstring,ConstDataHandle model_handle,char* data_name);
void  IoModelFetchData(double* pscalar,ConstDataHandle model_handle,char* data_name);
void  IoModelFetchData(int* pinteger,ConstDataHandle model_handle,char* data_name);

void WriteData(int* pdummy,void* data,char* data_type);
void WriteDataToDisk(void* data,int* pM,int* pN,char* datatype,FILE* fid);

#endif






#endif	/* _IO_H_ */
