/* \file WriteParams.c:
 * \brief: interface for writing parameters dataset into a matlab structure
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif


#ifdef _SERIAL_
#include <mex.h>

#include "../objects/Param.h"
#include "./io.h"
#include "../shared/shared.h"
#include "../include/macros.h"

void WriteParams(DataHandle* pdataref,Parameters* parameters){

	int i;

	/*output: */
	mxArray* dataref=NULL;
	mwSize nfields;
	const	char**	fnames=NULL;
	mwSize		onebyone[2] = {1,1};
	mwSize		ndim=2;

	/*intermediary: */
	Param*      param=NULL;

	/*Recover data from the parameters dataset: */
	nfields=(mwSize)parameters->Size();
	fnames=(const char**)xmalloc(nfields*sizeof(char*));
	
	/*Build structure in matlab workspace with all the parameter fields: */
	for(i=0;i<nfields;i++){
		param=(Param*)parameters->GetObjectByOffset(i);
		fnames[i]=param->GetParameterName();
	}
	/*Initialize structure: */
	dataref=mxCreateStructArray( ndim,onebyone,nfields,fnames);

	/*Fill each field: */
	for(i=0;i<nfields;i++){

		param=(Param*)parameters->GetObjectByOffset(i);
		param->SetMatlabField(dataref);
	}
		
	/*Assign output pointers:*/
	*pdataref=dataref;

}
#endif
