/*!\file PenaltySystemMatricesx
 * \brief: add penalties to system matrices
 */

#include "./PenaltySystemMatricesx.h"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void PenaltySystemMatricesx(Mat Kgg, Vec pg,double* pkmax,DataSet* elements,DataSet* nodes, DataSet* vertices,DataSet* loads,DataSet* materials, Parameters* parameters,
		int kflag,int pflag,int analysis_type,int sub_analysis_type){
	
	int i;

	extern int num_procs;
	extern int my_rank;
	double kmax;
	
	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Now, figure out maximum value of K_gg, so that we can penalize it correctly: */
	MatNorm(Kgg,NORM_INFINITY,&kmax);

	/*Add penalties to stiffnesses, from loads: */
	if(kflag)loads->PenaltyCreateKMatrix(Kgg,kmax,analysis_type,sub_analysis_type);
	if(pflag)loads->PenaltyCreatePVector(pg,kmax,analysis_type,sub_analysis_type);
	
	/*Assemble matrices: */
	if(kflag){
		MatAssemblyBegin(Kgg,MAT_FINAL_ASSEMBLY);
		MatAssemblyEnd(Kgg,MAT_FINAL_ASSEMBLY);
		MatCompress(Kgg);
	}
	if(pflag){
		VecAssemblyBegin(pg);
		VecAssemblyEnd(pg);
	}

	/*Assign output pointers:*/
	if(pkmax)*pkmax=kmax;

}
