/*!\file PenaltyConstraintsx
 * \brief: set up penalty constraints on loads
 */

#include "./PenaltyConstraintsx.h"
#include "./RiftConstraints.h"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void PenaltyConstraintsx(int* pconverged, int* pnum_unstable_constraints, DataSet* elements,DataSet* nodes, DataSet* vertices,
		DataSet* loads,DataSet* materials,  Parameters* parameters,int analysis_type,int sub_analysis_type){

	int i;

	extern int num_procs;
	extern int my_rank;
	
	/*output: */
	int converged=0;
	int num_unstable_constraints=0;
	int min_mechanical_constraints=0;

	/*recover parameters: */
	parameters->FindParam(&min_mechanical_constraints,"min_mechanical_constraints");

	/*First, get nodes and loads configured: */
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);

	/*Do we have penalties linked to rifts? In this case, run our special rifts penalty 
	 * management routine, otherwise, skip : */
	if (RiftIsPresent(loads)){
		RiftConstraints(&converged,&num_unstable_constraints,loads,min_mechanical_constraints,analysis_type,sub_analysis_type);
	}
	else if(loads->MeltingIsPresent()){
		loads->MeltingConstraints(&converged,&num_unstable_constraints,analysis_type,sub_analysis_type);
	}
	else{
		/*Do nothing, no constraints management!:*/
		num_unstable_constraints=0;
		converged=1;
	}

		
	/*Assign output pointers: */
	*pconverged=converged;
	*pnum_unstable_constraints=num_unstable_constraints;
}
