/*!\file: CreateParametersThermal.cpp
 * \brief driver for creating parameters dataset, for diagnostic horiz analysis.
 */ 

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../ModelProcessorx.h"

void CreateParametersThermal(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	Param*   param = NULL;
	Parameters* parameters=NULL;
	int      count;
	int i;
	double* u_g=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	/*return if 2d mesh*/
	if (strcmp(iomodel->meshtype,"2d")==0)goto cleanup_and_return;

	count=parameters->Size();

	/*Get vx vy and vz: */
	IoModelFetchData(&iomodel->vx,NULL,NULL,iomodel_handle,"vx");
	IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"vy");
	IoModelFetchData(&iomodel->vz,NULL,NULL,iomodel_handle,"vz");

	u_g=(double*)xcalloc(iomodel->numberofvertices*3,sizeof(double));

	if(iomodel->vx) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+0]=iomodel->vx[i]/iomodel->yts;
	if(iomodel->vy) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+1]=iomodel->vy[i]/iomodel->yts;
	if(iomodel->vz) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+2]=iomodel->vz[i]/iomodel->yts;

	count++;
	param= new Param(count,"u_g",DOUBLEVEC);
	param->SetDoubleVec(u_g,3*iomodel->numberofvertices,3);
	parameters->AddObject(param);

	xfree((void**)&iomodel->vx);
	xfree((void**)&iomodel->vy);
	xfree((void**)&iomodel->vz);
	xfree((void**)&u_g);
	
	/*Get pressure: */
	IoModelFetchData(&iomodel->pressure,NULL,NULL,iomodel_handle,"pressure");
	
	count++;
	param= new Param(count,"p_g",DOUBLEVEC);
	if(iomodel->pressure) param->SetDoubleVec(iomodel->pressure,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->pressure,0,0);
	parameters->AddObject(param);

	/*Free pressure: */
	xfree((void**)&iomodel->pressure);

	/* get initial temperature and melting if transient*/
	if(iomodel->dt){

		/*Get melting and temperature: */
		IoModelFetchData(&iomodel->temperature,NULL,NULL,iomodel_handle,"temperature");

		count++;
		param= new Param(count,"t_g",DOUBLEVEC);
		if(iomodel->temperature) param->SetDoubleVec(iomodel->temperature,iomodel->numberofvertices,1);
		else ISSMERROR("Missing initial temperature");
		parameters->AddObject(param);

		/*Free temperature: */
		xfree((void**)&iomodel->temperature);
	}

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pparameters=parameters;
}
