/*!\file: CreateParametersMelting.cpp
 * \brief driver for creating parameters dataset, for diagnostic horiz analysis.
 */ 

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../ModelProcessorx.h"

void CreateParametersMelting(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	Param*   param = NULL;
	Parameters* parameters=NULL;
	int      count;
	int i;

	/*recover parameters : */
	parameters=*pparameters;

	/*if 2d: return*/
	if (strcmp(iomodel->meshtype,"2d")==0)goto cleanup_and_return;

	count=parameters->Size();

	/* get initial melting_rate if transient*/
	if(iomodel->dt){

		/*Get melting_rate: */
		IoModelFetchData(&iomodel->melting_rate,NULL,NULL,iomodel_handle,"melting_rate");
		if(iomodel->melting_rate) {
			for(i=0;i<iomodel->numberofvertices;i++)iomodel->melting_rate[i]=iomodel->melting_rate[i]/iomodel->yts;   //m/s instead of m/yr
		}
		else{
			for(i=0;i<iomodel->numberofvertices;i++)iomodel->melting_rate[i]=0;
		}

		count++;
		param= new Param(count,"m_g",DOUBLEVEC);
		if(iomodel->melting_rate) param->SetDoubleVec(iomodel->melting_rate,iomodel->numberofvertices);
		else param->SetDoubleVec(iomodel->melting_rate,0);
		parameters->AddObject(param);

		/*Free melting_rate: */
		xfree((void**)&iomodel->melting_rate);
	}

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pparameters=parameters;
}
