/*
 * CreateElementsNodesAndMaterialsDiagnosticHutter.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../include/typedefs.h"
#include "../ModelProcessorx.h"

void	CreateElementsNodesAndMaterialsDiagnosticHutter(DataSet** pelements,DataSet** pnodes, DataSet** pvertices,DataSet** pmaterials, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i,j,k,n;

	/*DataSets: */
	DataSet*    elements  = NULL;
	DataSet*    nodes = NULL;
	DataSet*    vertices = NULL;
	DataSet*    materials = NULL;

	/*First create the elements, nodes and material properties: */
	elements  = new DataSet(ElementsEnum);
	nodes     = new DataSet(NodesEnum);
	vertices  = new DataSet(VerticesEnum);
	materials = new DataSet(MaterialsEnum);

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!iomodel->ishutter)goto cleanup_and_return;

	/*Partition elements and vertices and nodes: */
	Partitioning(&iomodel->my_elements, &iomodel->my_vertices, &iomodel->my_nodes, &iomodel->my_bordervertices, iomodel, iomodel_handle);

	/*Hutter elements can be partitioned using epart, even if
	 * each hutter elements either lies on a node (in 2d), or a pair of vertically juxtaposed nodes (in 3d): */

	/*Fetch data temporarily needed: */
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->gridonsurface,NULL,NULL,iomodel_handle,"gridonsurface");
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->uppernodes,NULL,NULL,iomodel_handle,"uppergrids");
	IoModelFetchData(&iomodel->drag_coefficient,NULL,NULL,iomodel_handle,"drag_coefficient");
	IoModelFetchData(&iomodel->rheology_B,NULL,NULL,iomodel_handle,"rheology_B");
	IoModelFetchData(&iomodel->rheology_n,NULL,NULL,iomodel_handle,"rheology_n");

	/*2d mesh: */
	if (strcmp(iomodel->meshtype,"2d")==0){

		for (i=0;i<iomodel->numberofvertices;i++){

			if(iomodel->my_vertices[i]){

				/*Create and add penta element to elements dataset: */
				elements->AddObject(new Sing(i+1,i,iomodel));

				/*Create and add material property to materials dataset: */
				materials->AddObject(new Matice(i+1,i,iomodel,1));

			}

		} //for (i=0;i<iomodel->numberofvertices;i++)
	} //if (strcmp(iomodel->meshtype,"2d")==0)
	else{

		for (i=0;i<iomodel->numberofvertices;i++){

			if(iomodel->my_vertices[i]){
				if(iomodel->gridonhutter[i]){
					if(!iomodel->gridonsurface[i]){ 

						/*Create and add penta element to elements dataset: */
						elements->AddObject(new Beam(i+1,i,iomodel));

						/*Create and add material property to materials dataset: */
						materials->AddObject(new Matice(i+1,i,iomodel,2));

					}
				}
			}

		} //for (i=0;i<iomodel->numberofvertices;i++)

	} //if (strcmp(iomodel->meshtype,"2d")==0)
	
	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->gridonhutter);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->surface);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->gridonsurface);
	xfree((void**)&iomodel->uppernodes);
	xfree((void**)&iomodel->drag_coefficient);
	xfree((void**)&iomodel->rheology_B);
	xfree((void**)&iomodel->rheology_n);

	/*Add new constrant material property to materials, at the end: */
	if (strcmp(iomodel->meshtype,"2d")==0){
		materials->AddObject(new Matpar(iomodel->numberofvertices+1,iomodel));                          //put it at the end of the materials
	}
	else{
		materials->AddObject(new Matpar(iomodel->numberofvertices2d*(iomodel->numlayers-1)+1,iomodel)); //put it at the end of the materials
	}
		
	/*First fetch data: */
	if (strcmp(iomodel->meshtype,"3d")==0){
		IoModelFetchData(&iomodel->deadgrids,NULL,NULL,iomodel_handle,"deadgrids");
		IoModelFetchData(&iomodel->uppernodes,NULL,NULL,iomodel_handle,"uppergrids");
	}
	IoModelFetchData(&iomodel->x,NULL,NULL,iomodel_handle,"x");
	IoModelFetchData(&iomodel->y,NULL,NULL,iomodel_handle,"y");
	IoModelFetchData(&iomodel->z,NULL,NULL,iomodel_handle,"z");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->gridonsurface,NULL,NULL,iomodel_handle,"gridonsurface");
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");
	IoModelFetchData(&iomodel->gridonicesheet,NULL,NULL,iomodel_handle,"gridonicesheet");
	IoModelFetchData(&iomodel->gridoniceshelf,NULL,NULL,iomodel_handle,"gridoniceshelf");

	for (i=0;i<iomodel->numberofvertices;i++){

		/*vertices and nodes (same number, as we are running continuous galerkin formulation: */
		if(iomodel->my_vertices[i]){

			/*Add vertex to vertices dataset: */
			vertices->AddObject(new Vertex(i+1,i,iomodel));

			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(i+1,i,iomodel));

		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->deadgrids);
	xfree((void**)&iomodel->x);
	xfree((void**)&iomodel->y);
	xfree((void**)&iomodel->z);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->gridonsurface);
	xfree((void**)&iomodel->gridonhutter);
	xfree((void**)&iomodel->uppernodes);
	xfree((void**)&iomodel->gridonicesheet);
	xfree((void**)&iomodel->gridoniceshelf);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	elements->Presort();
	nodes->Presort();
	vertices->Presort();
	materials->Presort();

	cleanup_and_return:

	/*Assign output pointer: */
	*pelements=elements;
	*pnodes=nodes;
	*pvertices=vertices;
	*pmaterials=materials;
}
