/*!\file: CreateParametersControl.cpp
 * \brief driver for creating parameters dataset, for control analysis.
 */ 

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../ModelProcessorx.h"

void CreateParametersControl(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	int i;
	
	Parameters* parameters=NULL;
	Param*   param = NULL;
	int      count;

	double* param_g=NULL;
	double* u_g_obs=NULL;
	double* control_parameter=NULL;

	/*Get parameters: */
	parameters=*pparameters;
	count=parameters->Size();
	
	//control analysis?
	count++;
	param= new Param(count,"control_analysis",DOUBLE);
	param->SetDouble(iomodel->control_analysis);
	parameters->AddObject(param);
	
	if(iomodel->control_analysis){

		/*control_type: */
		count++;
		param= new Param(count,"control_type",STRING);
		param->SetString(iomodel->control_type);
		parameters->AddObject(param);

		/*extrude_param: */
		count++;
		param= new Param(count,"extrude_param",DOUBLE);
		if (strcmp(iomodel->control_type,"drag")==0)   param->SetDouble(0);
		else if (strcmp(iomodel->control_type,"B")==0) param->SetDouble(1);
		else ISSMERROR("control_type %s not supported yet!",iomodel->control_type);
		parameters->AddObject(param);

		/*control_steady: */
		count++;
		param= new Param(count,"control_steady",DOUBLE);
		param->SetDouble(0);
		parameters->AddObject(param);

		/*nsteps: */
		count++;
		param= new Param(count,"nsteps",DOUBLE);
		param->SetDouble(iomodel->nsteps);
		parameters->AddObject(param);

		/*tolx: */
		count++;
		param= new Param(count,"tolx",DOUBLE);
		param->SetDouble(iomodel->tolx);
		parameters->AddObject(param);

		/*eps_cm: */
		count++;
		param= new Param(count,"eps_cm",DOUBLE);
		param->SetDouble(iomodel->eps_cm);
		parameters->AddObject(param);

		/*meanvel: */
		count++;
		param= new Param(count,"meanvel",DOUBLE);
		param->SetDouble(iomodel->meanvel);
		parameters->AddObject(param);

		/*cm_noisedmp: */
		count++;
		param= new Param(count,"cm_noisedmp",DOUBLE);
		param->SetDouble(iomodel->cm_noisedmp);
		parameters->AddObject(param);

		/*cm_mindmp_value: */
		count++;
		param= new Param(count,"cm_mindmp_value",DOUBLE);
		param->SetDouble(iomodel->cm_mindmp_value);
		parameters->AddObject(param);

		/*cm_mindmp_slope: */
		count++;
		param= new Param(count,"cm_mindmp_slope",DOUBLE);
		param->SetDouble(iomodel->cm_mindmp_slope);
		parameters->AddObject(param);

		/*cm_maxdmp_value: */
		count++;
		param= new Param(count,"cm_maxdmp_value",DOUBLE);
		param->SetDouble(iomodel->cm_maxdmp_value);
		parameters->AddObject(param);

		/*cm_maxdmp_slope: */
		count++;
		param= new Param(count,"cm_maxdmp_slope",DOUBLE);
		param->SetDouble(iomodel->cm_maxdmp_slope);
		parameters->AddObject(param);
		
		/*cm_min: */
		count++;
		param= new Param(count,"cm_min",DOUBLE);
		param->SetDouble(iomodel->cm_min);
		parameters->AddObject(param);

		/*cm_max: */
		count++;
		param= new Param(count,"cm_max",DOUBLE);
		param->SetDouble(iomodel->cm_max);
		parameters->AddObject(param);

		/*cm_gradient: */
		count++;
		param= new Param(count,"cm_gradient",DOUBLE);
		param->SetDouble(iomodel->cm_gradient);
		parameters->AddObject(param);

		/*Now, recover fit, optscal and maxiter as vectors: */
		IoModelFetchData(&iomodel->fit,NULL,NULL,iomodel_handle,"fit");
		IoModelFetchData(&iomodel->cm_jump,NULL,NULL,iomodel_handle,"cm_jump");
		IoModelFetchData(&iomodel->optscal,NULL,NULL,iomodel_handle,"optscal");
		IoModelFetchData(&iomodel->maxiter,NULL,NULL,iomodel_handle,"maxiter");

		count++;
		param= new Param(count,"fit",DOUBLEVEC);
		param->SetDoubleVec(iomodel->fit,iomodel->nsteps);
		parameters->AddObject(param);

		count++;
		param= new Param(count,"cm_jump",DOUBLEVEC);
		param->SetDoubleVec(iomodel->cm_jump,iomodel->nsteps);
		parameters->AddObject(param);

		count++;
		param= new Param(count,"optscal",DOUBLEVEC);
		param->SetDoubleVec(iomodel->optscal,iomodel->nsteps);
		parameters->AddObject(param);

		count++;
		param= new Param(count,"maxiter",DOUBLEVEC);
		param->SetDoubleVec(iomodel->maxiter,iomodel->nsteps);
		parameters->AddObject(param);

		xfree((void**)&iomodel->fit);
		xfree((void**)&iomodel->cm_jump);
		xfree((void**)&iomodel->optscal);
		xfree((void**)&iomodel->maxiter);

		/*Now, recover weights as vectors: */
		IoModelFetchData(&iomodel->weights,NULL,NULL,iomodel_handle,"weights");

		count++;
		param= new Param(count,"weights",DOUBLEVEC);
		param->SetDoubleVec(iomodel->weights,iomodel->numberofvertices);
		parameters->AddObject(param);

		xfree((void**)&iomodel->weights);

		/*Get vx, vx_obs, vy, vy_obs, and the parameter value: */
		IoModelFetchData(&iomodel->vx,NULL,NULL,iomodel_handle,"vx");
		IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"vy");
		IoModelFetchData(&iomodel->vz,NULL,NULL,iomodel_handle,"vz");
		IoModelFetchData(&iomodel->vx_obs,NULL,NULL,iomodel_handle,"vx_obs");
		IoModelFetchData(&iomodel->vy_obs,NULL,NULL,iomodel_handle,"vy_obs");
		IoModelFetchData(&control_parameter,NULL,NULL,iomodel_handle,iomodel->control_type);

		u_g_obs=(double*)xcalloc(iomodel->numberofvertices*2,sizeof(double));
		if(iomodel->vx_obs)for(i=0;i<iomodel->numberofvertices;i++)u_g_obs[2*i+0]=iomodel->vx_obs[i]/iomodel->yts;
		if(iomodel->vy_obs)for(i=0;i<iomodel->numberofvertices;i++)u_g_obs[2*i+1]=iomodel->vy_obs[i]/iomodel->yts;

		count++;
		param= new Param(count,"u_g_obs",DOUBLEVEC);
		param->SetDoubleVec(u_g_obs,2*iomodel->numberofvertices,2);
		parameters->AddObject(param);
		
		param_g=(double*)xcalloc(iomodel->numberofvertices,sizeof(double));
		for(i=0;i<iomodel->numberofvertices;i++)param_g[i]=control_parameter[i];

		count++;
		param= new Param(count,"param_g",DOUBLEVEC);
		param->SetDoubleVec(param_g,iomodel->numberofvertices,1);
		parameters->AddObject(param);

		xfree((void**)&iomodel->vx);
		xfree((void**)&iomodel->vy);
		xfree((void**)&iomodel->vz);
		xfree((void**)&iomodel->vx_obs);
		xfree((void**)&iomodel->vy_obs);
		xfree((void**)&u_g_obs);
		xfree((void**)&param_g);
		xfree((void**)&control_parameter);
	}

	/*Assign output pointer: */
	*pparameters=parameters;
}
