/*!\file: CreateParametersBalancedvelocities.cpp
 * \brief driver for creating parameters dataset, for prognostic analysis.
 */ 

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../ModelProcessorx.h"

void CreateParametersBalancedvelocities(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	Param*   param = NULL;
	Parameters* parameters=NULL;
	int      count;
	int      i;
	double* u_g=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	/*Get vx and vy: */
	IoModelFetchData(&iomodel->vx,NULL,NULL,iomodel_handle,"vx");
	IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"vy");
	IoModelFetchData(&iomodel->vz,NULL,NULL,iomodel_handle,"vz");

	u_g=(double*)xcalloc(iomodel->numberofvertices*3,sizeof(double));

	if(iomodel->vx) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+0]=iomodel->vx[i]/iomodel->yts;
	if(iomodel->vy) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+1]=iomodel->vy[i]/iomodel->yts;
	if(iomodel->vz) for(i=0;i<iomodel->numberofvertices;i++)u_g[3*i+2]=iomodel->vz[i]/iomodel->yts;

	count++;
	param= new Param(count,"u_g",DOUBLEVEC);
	param->SetDoubleVec(u_g,3*iomodel->numberofvertices,3);
	parameters->AddObject(param);

	xfree((void**)&iomodel->vx);
	xfree((void**)&iomodel->vy);
	xfree((void**)&iomodel->vz);
	xfree((void**)&u_g);

	/*Get thickness: */
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	
	count++;
	param= new Param(count,"h_g",DOUBLEVEC);
	if(iomodel->thickness) param->SetDoubleVec(iomodel->thickness,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->thickness,0,0);
	parameters->AddObject(param);

	/*Free thickness: */
	xfree((void**)&iomodel->thickness);

	/*Get melting_rate: */
	IoModelFetchData(&iomodel->melting_rate,NULL,NULL,iomodel_handle,"melting_rate");
	if(iomodel->melting_rate) for(i=0;i<iomodel->numberofvertices;i++)iomodel->melting_rate[i]=iomodel->melting_rate[i]/iomodel->yts;
	
	count++;
	param= new Param(count,"m_g",DOUBLEVEC);
	if(iomodel->melting_rate) param->SetDoubleVec(iomodel->melting_rate,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->melting_rate,0,1);
	parameters->AddObject(param);

	/*Free melting_rate: */
	xfree((void**)&iomodel->melting_rate);

	/*Get accumulation_rate: */
	IoModelFetchData(&iomodel->accumulation_rate,NULL,NULL,iomodel_handle,"accumulation_rate");
	if(iomodel->accumulation_rate) for(i=0;i<iomodel->numberofvertices;i++)iomodel->accumulation_rate[i]=iomodel->accumulation_rate[i]/iomodel->yts;
	
	count++;
	param= new Param(count,"a_g",DOUBLEVEC);
	if(iomodel->accumulation_rate) param->SetDoubleVec(iomodel->accumulation_rate,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->accumulation_rate,0,0);
	parameters->AddObject(param);

	/*Free accumulation_rate: */
	xfree((void**)&iomodel->accumulation_rate);


	/*Assign output pointer: */
	*pparameters=parameters;
}
