/*!\file: CreateParametersPrognostic.cpp
 * \brief driver for creating parameters dataset, for prognostic analysis.
 */ 

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../ModelProcessorx.h"

void CreateParametersBalancedthickness2(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	Param*   param = NULL;
	Parameters* parameters=NULL;
	int      count;
	int      i;
	int      dim;
	double*  vx_g=NULL;
	double*  vy_g=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	/*Get vx and vy: */
	IoModelFetchData(&iomodel->vx,NULL,NULL,iomodel_handle,"vx");
	IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"vy");

	vx_g=(double*)xcalloc(iomodel->numberofvertices,sizeof(double));
	vy_g=(double*)xcalloc(iomodel->numberofvertices,sizeof(double));

	if(iomodel->vx) for(i=0;i<iomodel->numberofvertices;i++)vx_g[i]=iomodel->vx[i]/iomodel->yts;
	if(iomodel->vy) for(i=0;i<iomodel->numberofvertices;i++)vy_g[i]=iomodel->vy[i]/iomodel->yts;

	count++;
	param= new Param(count,"vx_g",DOUBLEVEC);
	param->SetDoubleVec(vx_g,iomodel->numberofvertices,1);
	parameters->AddObject(param);
	count++;
	param= new Param(count,"vy_g",DOUBLEVEC);
	param->SetDoubleVec(vy_g,iomodel->numberofvertices,1);
	parameters->AddObject(param);

	xfree((void**)&iomodel->vx);
	xfree((void**)&iomodel->vy);
	xfree((void**)&vx_g);
	xfree((void**)&vy_g);

	/*Get thickness: */
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");

	count++;
	param= new Param(count,"h_g",DOUBLEVEC);
	if(iomodel->thickness) param->SetDoubleVec(iomodel->thickness,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->thickness,0,0);
	parameters->AddObject(param);

	/*Free thickness: */
	xfree((void**)&iomodel->thickness);

	/*Get dhdt: */
	IoModelFetchData(&iomodel->dhdt,NULL,NULL,iomodel_handle,"dhdt");
	if(iomodel->dhdt) for(i=0;i<iomodel->numberofvertices;i++)iomodel->dhdt[i]=iomodel->dhdt[i]/iomodel->yts;

	count++;
	param= new Param(count,"dhdt_g",DOUBLEVEC);
	if(iomodel->dhdt) param->SetDoubleVec(iomodel->dhdt,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->dhdt,0,1);
	parameters->AddObject(param);

	/*Free dhdt: */
	xfree((void**)&iomodel->dhdt);

	/*Get melting_rate: */
	IoModelFetchData(&iomodel->melting_rate,NULL,NULL,iomodel_handle,"melting_rate");
	if(iomodel->melting_rate) for(i=0;i<iomodel->numberofvertices;i++)iomodel->melting_rate[i]=iomodel->melting_rate[i]/iomodel->yts;
	
	count++;
	param= new Param(count,"m_g",DOUBLEVEC);
	if(iomodel->melting_rate) param->SetDoubleVec(iomodel->melting_rate,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->melting_rate,0,1);
	parameters->AddObject(param);

	/*Free melting_rate: */
	xfree((void**)&iomodel->melting_rate);

	/*Get accumulation_rate: */
	IoModelFetchData(&iomodel->accumulation_rate,NULL,NULL,iomodel_handle,"accumulation_rate");
	if(iomodel->accumulation_rate) for(i=0;i<iomodel->numberofvertices;i++)iomodel->accumulation_rate[i]=iomodel->accumulation_rate[i]/iomodel->yts;
	
	count++;
	param= new Param(count,"a_g",DOUBLEVEC);
	if(iomodel->accumulation_rate) param->SetDoubleVec(iomodel->accumulation_rate,iomodel->numberofvertices,1);
	else param->SetDoubleVec(iomodel->accumulation_rate,0,0);
	parameters->AddObject(param);

	/*Free accumulation_rate: */
	xfree((void**)&iomodel->accumulation_rate);

	/*Assign output pointer: */
	*pparameters=parameters;
}
