/*! \file Parameters.h 
 *  \brief: header file for inputs object
 */

#ifndef _PARAMETERS_H_
#define _PARAMETERS_H_

#include "./DataSet.h"

class Parameters: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Parameters();
		Parameters(int enum_type);
		~Parameters();
		/*}}}*/
		/*numerics: {{{1*/
		int   FindParam(double* pscalar, int enum_type);
		int   FindParam(int* pinteger,int enum_type);
		int   FindParam(char** pstring,int enum_type);
		int   FindParam(char*** pstringarray,int* pM,int enum_type);
		int   FindParam(double** pdoublearray,int* pM,int enum_type);
		int   FindParam(double** pdoublearray,int* pM,int* pN,int enum_type);
		int   FindParam(Vec* pvec,int enum_type);
		int   FindParam(Mat* pmat,int enum_type);
		Object* FindParamObject(int enum_type);
		/*}}}*/

};
#endif  /* _PARAMETERS_H */
