/*!\file ConfigureObjectsx
 * \brief: configure objects in elements and loads to link in with nodes
 */

#include "./ConfigureObjectsx.h"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

int	ConfigureObjectsx( DataSet* elements, DataSet* loads, DataSet* nodes, DataSet* vertices, DataSet* materials,Parameters* parameters){

	int noerr=1;
	int i;

	extern int num_procs;
	extern int my_rank;
	
	//_printf_("      Configuring elements...\n");
	elements->Configure(elements,loads,nodes,vertices,materials,parameters);
	//_printf_("      Configuring loads...\n");
	loads->Configure(elements,loads,nodes,vertices,materials,parameters);
	//_printf_("      Configuring nodes...\n");
	nodes->Configure(elements,loads,nodes,vertices,materials,parameters);
	//_printf_("      Configuring parameters...\n");
	parameters->Configure(elements,loads,nodes,vertices,materials,parameters);

	return noerr;
}
