/*!\file ComputeBasalStressx
 * \brief: compute pressure according to each element
 */

#include "./ComputeBasalStressx.h"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void	ComputeBasalStressx( Vec* psigma,DataSet* elements,DataSet* nodes, DataSet* vertices,DataSet* loads, DataSet* materials,Parameters* parameters,
			int analysis_type,int sub_analysis_type){

	int i;

	int  found=0;
	double numberofelements;

	/*output: */
	Vec sigma=NULL;

	/*Recover numberofelements: */
	found= parameters->FindParam(&numberofelements,"numberofelements");
	if (!found) ISSMERROR("numberofelements not provided in parameters");

	/*Allocate sigma on numberofelements: */
	sigma=NewVec((int)numberofelements);

	/*Get elements configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Call on dataset driver: */
	elements->ComputeBasalStress(sigma,analysis_type,sub_analysis_type);

	/*Assemble vector: */
	VecAssemblyBegin(sigma);
	VecAssemblyEnd(sigma);

	/*Assign output pointers: */
	*psigma=sigma;
	
}
