/*!\file Input.h
 * \brief: header file for input object
 */

#ifndef _INPUT_H_
#define _INPUT_H_

#include "./Param.h" //for enums STRING,INTEGER,DOUBLE AND DOUBLEVEC
#include "./Node.h"

#define INPUTSTRING 200 //max string length

class Input: public Object {

	private: 
		char name[INPUTSTRING]; //"analysis_type","velocity", etc ...
		int  type; //STRING, INTEGER, DOUBLE OR DOUBLEVEC

		/*placeholders: */
		char string[INPUTSTRING];
		int  integer;
		double scalar;
		double* vector;
		
		int  ndof; //number of dofs for input array
		int  numberofnodes; //size of input array for each dof

	public:

		/*constructors and destructors: */
		Input();
		~Input();
		Input(char* name,char* string);
		Input(char* name,int integer);
		Input(char* name,double scalar);
		Input(char* name,double* vector,int ndof,int numberofnodes);
		Input(char* name,Vec petscvector,int ndof, int numberofnodes);

		
		Object* copy();

		/*fill virtual routines: */
		void  Echo();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		int   MyRank();

		/*Input specific routines: */
		int   IsSameName(char* input_name);
		void  Recover(double* values, int ndof, int* dofs,int numnodes,void** nodes);
		void  Recover(int* pinteger);
		void  Recover(char** pstring);
		void  Recover(double* pdouble);

		/*get into workspace: */
		Vec   Get(int* dofs, int numdofs);

};

#endif  /* _INPUT_H_ */
