/*!\file:  ParameterInputs.h
 * \brief dataset filled with input objects. Used by CreateKMatrix and CreatePVector  to hold 
 * parameters coming from the workspace.
 */ 

#ifndef _PARAMETERINPUTS_H_
#define _PARAMETERINPUTS_H_

#include "../toolkits/toolkits.h"
#include "../DataSet/DataSet.h"

class DataSet;

class ParameterInputs{

	private: 
		DataSet* dataset; //cannot declare DataSet* dataset, to avoid circular referencing.

	public:
		ParameterInputs();
		~ParameterInputs();
		void Echo();
		
		void Add(char* name,char* string);
		void Add(char* name,int integer);
		void Add(char* name,double scalar);
		void Add(char* name,double* vector,int ndof,int numberofnodes);
		void Add(char* name,Vec petscvector,int ndof, int numberofnodes);

		int  Recover(char* name, char** pstring);
		int  Recover(char* name, int* pinteger);
		int  Recover(char* name, double* pscalar);
		int  Recover(char* name,double* values, int ndof, int* dofs,int numnodes,void** nodes); //void** because otherwise we get a circular dependency with Node

		Vec  Get(char* field_name,int* dofs, int numdofs);

		/*declaration found in io: */
		void Init( void* data_handle);
		void purge(char* name);
};

#endif
