/*!\file ParameterInputs.c
 * \brief: implementation of the ParameterInputs object
 */


#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../include/typedefs.h"
#include "../include/macros.h"
#include "./objects.h"

ParameterInputs::ParameterInputs(){

	dataset=new DataSet();

}
		
ParameterInputs::~ParameterInputs(){

	delete dataset;

}

void ParameterInputs::Echo(){

	printf("ParameterInputs echo: \n");
	dataset->Echo();

}

void ParameterInputs::purge(char* name){

	int i;
	Input* input=NULL;

	/*Go through dataset, and figure out if an Input 
	 * already has the name "name". If so, delete it : */
	
	for(i=0;i<dataset->Size();i++){
		input=(Input*)dataset->GetObjectByOffset(i);

		if (input->IsSameName(name)){
			/*delete object: */
			dataset->DeleteObject(input);
		}
	}
}
		

void ParameterInputs::Add(char* name,char* string){

	Input* input=NULL;

	/*First, purge object with same name: */
	this->purge(name);

	/*We are sure an input of the same name does not exist. Create new 
	 * input: */
	input=new Input(name,string);

	/*Add input to dataset: */
	dataset->AddObject(input);

}

void ParameterInputs::Add(char* name,int integer){
	
	Input* input=NULL;

	/*First, purge object with same name: */
	this->purge(name);

	/*We are sure an input of the same name does not exist. Create new 
	 * input: */
	input=new Input(name,integer);

	/*Add input to dataset: */
	dataset->AddObject(input);
}


void ParameterInputs::Add(char* name,double scalar){

	Input* input=NULL;

	/*First, purge object with same name: */
	this->purge(name);

	/*We are sure an input of the same name does not exist. Create new 
	 * input: */
	input=new Input(name,scalar);

	/*Add input to dataset: */
	dataset->AddObject(input);

}

void ParameterInputs::Add(char* name,double* vector,int ndof,int numberofnodes){
	
	Input* input=NULL;

	/*First, purge object with same name: */
	this->purge(name);

	/*We are sure an input of the same name does not exist. Create new 
	 * input: */
	input=new Input(name,vector,ndof,numberofnodes);

	/*Add input to dataset: */
	dataset->AddObject(input);

}

void ParameterInputs::Add(char* name,Vec petscvector,int ndof, int numberofnodes){
	
	Input* input=NULL;

	/*First, purge object with same name: */
	this->purge(name);

	/*We are sure an input of the same name does not exist. Create new 
	 * input: */
	input=new Input(name,petscvector,ndof,numberofnodes);

	/*Add input to dataset: */
	dataset->AddObject(input);

}
int ParameterInputs::Recover(char* name, char** pstring){

	int found=0;
	int i;
	Input* input=NULL;
	char* string=NULL;

	/*Go through dataset, and figure out if an Input 
	 * has the name "name": */
	for(i=0;i<dataset->Size();i++){
		input=(Input*)dataset->GetObjectByOffset(i);

		if (input->IsSameName(name)){

			/*Get string out of this input: */
			input->Recover(&string);
			found=1;break;
		}
	}
	/*Assign output pointers:*/
	*pstring=string;
	return found;

}
int ParameterInputs::Recover(char* name, int* pinteger){
	
	int found=0;
	int i;
	Input* input=NULL;
	int integer;

	/*Go through dataset, and figure out if an Input 
	 * has the name "name": */
	for(i=0;i<dataset->Size();i++){
		input=(Input*)dataset->GetObjectByOffset(i);

		if (input->IsSameName(name)){

			/*Get string out of this input: */
			input->Recover(&integer);
			found=1; break;

		}
	}
	/*Assign output pointers:*/
	*pinteger=integer;

	return found;
}
int ParameterInputs::Recover(char* name, double* pscalar){

	int found=0;
	int i;
	Input* input=NULL;
	double scalar;

	/*Go through dataset, and figure out if an Input 
	 * has the name "name": */
	for(i=0;i<dataset->Size();i++){
		input=(Input*)dataset->GetObjectByOffset(i);

		if (input->IsSameName(name)){

			/*Get string out of this input: */
			input->Recover(&scalar);
			found=1; break;

		}
	}
	/*Assign output pointers:*/
	*pscalar=scalar;

	return found;

}

#undef __FUNCT__
#define __FUNCT__ "ParameterInputs::Recover"
int ParameterInputs::Recover(char* name,double* values, int ndof, int* dofs,int numnodes,void** pnodes){

	int i;
	Node** nodes=NULL;
	Input* input=NULL;
	int found=0;

	/*First recover nodes pointer :*/
	nodes=(Node**)pnodes;

	/*Go through dataset, and figure out if an Input 
	 * has the name "name": */
	for(i=0;i<dataset->Size();i++){
		input=(Input*)dataset->GetObjectByOffset(i);

		if (input->IsSameName(name)){
			found=1;
			break;
		}
	}

	if(found==0)return 0;
	
	/*call submethod: */
	input->Recover(values,ndof,dofs,numnodes,(void**)nodes);
	return 1;
}
		
#undef __FUNCT__
#define __FUNCT__ "ParameterInputs::Get"
Vec ParameterInputs::Get(char* name,int* dofs, int numdofs){
	
	int i;
	Input* input=NULL;
	int found=0;
	
	/*output: */
	Vec ug=NULL;

	/*Go through dataset, and figure out if an Input 
	 * has the name "name": */
	for(i=0;i<dataset->Size();i++){
		input=(Input*)dataset->GetObjectByOffset(i);

		if (input->IsSameName(name)){
			found=1;
			break;
		}
	}

	if(found==0)return NULL;
	
	/*call submethod: */
	ug=input->Get(dofs,numdofs);

	return ug;
}
