function geom=processgeometry(geom,tol,outline);

%Deal with edges
disp('Checking Edge crossing...');
i=0;
while (i<size(geom.Edges,1)),

	%edge counter
	i=i+1;

	%Get coordinates
	x1=geom.Vertices(geom.Edges(i,1),1);
	y1=geom.Vertices(geom.Edges(i,1),2);
	x2=geom.Vertices(geom.Edges(i,2),1);
	y2=geom.Vertices(geom.Edges(i,2),2);

	j=i+1; %test edges located AFTER i only
	while (j<size(geom.Edges,1)),

		%edge counter
		j=j+1;

		%Skip if the two edges already have a vertex in common
		if any(ismember(geom.Edges(i,1:2),geom.Edges(j,1:2))),
			continue
		end

		%Get coordinates
		x3=geom.Vertices(geom.Edges(j,1),1);
		y3=geom.Vertices(geom.Edges(j,1),2);
		x4=geom.Vertices(geom.Edges(j,2),1);
		y4=geom.Vertices(geom.Edges(j,2),2);

		%Check if the two edges are crossing one another
		if SegIntersect([x1 y1; x2 y2],[x3 y3; x4 y4]),

			%Get coordinate of intersection point (http://mathworld.wolfram.com/Line-LineIntersection.html)
			x=det([det([x1 y1; x2 y2])  x1-x2;det([x3 y3; x4 y4])  x3-x4])/det([x1-x2 y1-y2;x3-x4 y3-y4]);
			y=det([det([x1 y1; x2 y2])  y1-y2;det([x3 y3; x4 y4])  y3-y4])/det([x1-x2 y1-y2;x3-x4 y3-y4]);

			%Add vertex to the list of vertices
			geom.Vertices(end+1,:)=[x y 1];
			id=size(geom.Vertices,1);

			%Update edges i and j
			edgei=geom.Edges(i,:);
			edgej=geom.Edges(j,:);
			geom.Edges(i,:)    =[edgei(1) id       edgei(3)];
			geom.Edges(end+1,:)=[id       edgei(2) edgei(3)];
			geom.Edges(j,:)    =[edgej(1) id       edgej(3)];
			geom.Edges(end+1,:)=[id       edgej(2) edgej(3)];

			%update current edge second tip
			x2=x; y2=y;
		end
	end

end

%Check point spacing
if ~isnan(tol),
	disp('Checking point spacing...');
	i=0;
	while (i<size(geom.Vertices,1)),

		%vertex counter
		i=i+1;

		%Get coordinates
		x1=geom.Vertices(i,1);
		y1=geom.Vertices(i,2);

		j=i; %test edges located AFTER i only
		while (j<size(geom.Vertices,1)),

			%vertex counter
			j=j+1;

			%Get coordinates
			x2=geom.Vertices(j,1);
			y2=geom.Vertices(j,2);

			%Check whether the two vertices are too close
			if ((x2-x1)^2+(y2-y1)^2<tol^2)

				%Remove points from list of Vertices
				geom.Vertices(j,:)=[];

				%update edges
				posedges=find(ismember(geom.Edges,j));
				geom.Edges(posedges)=i;
				posedges=find(geom.Edges>j);
				geom.Edges(posedges)=geom.Edges(posedges)-1;

				%update counter
				j=j-1;

			end
		end
	end
end
%remove empty edges
geom.Edges(find(geom.Edges(:,1)==geom.Edges(:,2)),:)=[];

%Check point outside
disp('Checking for points outside the domain...');
i=0;
num=0;
while (i<size(geom.Vertices,1)),

	%vertex counter
	i=i+1;

	%Get coordinates
	x=geom.Vertices(i,1);
	y=geom.Vertices(i,2);

	%Check that the point is inside the domain
	if (~ContourToNodes(x,y,outline(1),1)),

		%Remove points from list of Vertices
		num=num+1;
		geom.Vertices(i,:)=[];

		%update edges
		[posedges dummy]=find(geom.Edges==i);
		geom.Edges(posedges,:)=[];
		posedges=find(geom.Edges>i);
		geom.Edges(posedges)=geom.Edges(posedges)-1;

		%update counter
		i=i-1;
	end
end
if num,
	disp(['WARNING: ' num2str(num) 'points outside the domain outline have been removed']);
end
