function QueueRequirements(cluster,queue,np,time)
%QUEUEREQUIREMENTS queue requirements in time, number of cpus, by name of queue.
%
%
% Usage: QueueRequirements(cluster,queue,np,time)
%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cluster settings%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if strcmpi(cluster,'cosmos'),

	available_queues={'debug','shortq','longq','specialq'};
	queue_requirements_time=[60*1 60*3 60*17 1440];
	queue_requirements_np=[32 128 256 256];
	queue_requirements_modulo=[1 1 1 1];

elseif strcmpi(cluster,'gemini'),

	available_queues={'debug','shortg','longg'};
	queue_requirements_time=[60 180 720];
	queue_requirements_np=[50 50 50];
	queue_requirements_modulo=[1 1 1 ];

elseif strcmpi(cluster,'castor'),

	available_queues={'shortc','longc'};
	queue_requirements_time=[180 720];
	queue_requirements_np=[128 128];
	queue_requirements_modulo=[1 1 ];

elseif strcmpi(cluster,'pollux'),

	available_queues={'shortp','longp'};
	queue_requirements_time=[180 720];
	queue_requirements_np=[128 128];
	queue_requirements_modulo=[1 1 ];

elseif strcmpi(cluster,'astrid'),

	available_queues={'none'};
	queue_requirements_time=[Inf];
	queue_requirements_np=[16];
	queue_requirements_modulo=[1 ];

elseif strcmpi(cluster,'larsen'),

	available_queues={'none'};
	queue_requirements_time=[Inf];
	queue_requirements_np=[8];
	queue_requirements_modulo=[1 ];

elseif strcmpi(cluster,'wilkes'),

	available_queues={'none'};
	queue_requirements_time=[Inf];
	queue_requirements_np=[16];
	queue_requirements_modulo=[1 ];

elseif strcmpi(cluster,'pfe'),

	available_queues={'long'};
	queue_requirements_time=[7200];
	queue_requirements_np=[2048];
	queue_requirements_modulo=[8 ];

else
	error(['BuildQueueingScript error message: cannot find requirements for ' cluster ]);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%end settings%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Ok, go through requirements for current queue:
index=ismemberi(queue,available_queues);
if  ~index,
	%ok, either we a generic cluster, with 'none' queue, or we could not find the queue reqruirements
	if strcmpi(available_queues{1},'none'),
		%reset index to 1, so we can fish the requirements
		index=1;
	else
		string=available_queues{1};
		for i=2:length(available_queues),
			string=[string ' ' available_queues{i}];
		end
		error(['QueueRequirements error message: availables queues are ' string]);
	end
end

%check on time requirements
rtime=queue_requirements_time(index);

if time<=0,
	error('QueueRequirements: time should be a positive number');
end

if time>rtime,
	error(['QueueRequirements: time should be < ' num2str(rtime) ' for queue: ' queue]);
end

%check on np requirements
rnp=queue_requirements_np(index);
rmod=queue_requirements_modulo(index);

if np<=0,
	error('QueueRequirements: np should be a positive number');
end

if np>rnp,
	error(['QueueRequirements: np should be < ' num2str(rnp) ' for queue: ' queue]);
end

%check np is a multiple of the queue multiple 
if mod(np,rmod),
	error(['QueueRequirements: np should be a multiple of ' num2str(rmod) ' for queue: ' queue]);
end
