#!/bin/bash

# Some cleanup
rm -rf scotch_5.1
rm -rf src 
rm -rf install 

# Create src and install directories
mkdir src install 

# Untar 
tar -xvzf scotch_5.1.6.tar.gz

# Move scotch to src directory
mv scotch_5.1/* src
rm -rf scotch_5.1

# Apply patches (all at once, since many)
# (written by diff -rc src ~/Libs/scotch_5.1 > scotch.patch)
patch -p0 < scotch.patch

# Build scotch
cp -p Makefile.inc src/src
cp -p gmap_mex.c src/src/scotch
cp -p gmapx.c src/src/scotch
cd src/src
# For stand-alone scotch modules:
make scotch
make clean
# For mex scotch modules:
make mexscotch
# Clean up
make clean
cd ../..

# Populate install directory
cp -pr src/grf install
cp -pr src/tgt install
cp -pr src/doc install
cp -pr src/man install
mkdir install/bin
mv src/bin/* install/bin
cp -p gmap.m install/bin
cp -p gpart.m install/bin

