function u_g=diagnostic_core_linear(m,inputs,analysis_type)
%DIAGNOSTIC_CORE_LINEAR - linear solution sequence
%
%   Usage:
%      u_g=diagnostic_core_linear(m,inputs,analysis_type)

	%stiffness and load generation only:
	m.parameters.kflag=1; m.parameters.pflag=1;

	%Update inputs in datasets
	[m.elements,m.nodes, m.loads,m.materials]=UpdateFromInputs(m.elements,m.nodes, m.loads,m.materials,inputs);
	
	%system matrices
	[K_gg, p_g]=SystemMatrices(m.elements,m.nodes,m.loads,m.materials,m.parameters,inputs,analysis_type);
	
	%Reduce tangent matrix from g size to f size
	[K_ff, K_fs] = Reducematrixfromgtof( K_gg, m.Gmn, m.nodesets); 
	
	%Reduce load from g size to f size
	[p_f] = Reduceloadfromgtof( p_g, m.Gmn, K_fs, m.ys, m.nodesets);
	
	%Solve	
	[u_f]=Solver(K_ff,p_f,[],m.parameters);
	
	%Merge back to g set
	[u_g]= Mergesolutionfromftog( u_f, m.Gmn, m.ys, m.nodesets ); 

end %end function
