/*! \file TriaVertexInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _TRIAVERTEXINPUT_H_
#define _TRIAVERTEXINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
/*}}}*/

class TriaVertexInput: public Input{

	private: 
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		double values[3];

	public:

		/*constructors, destructors: {{{1*/
		TriaVertexInput();
		TriaVertexInput(int enum_type,double* values);
		~TriaVertexInput();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   GetId(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();

		/*}}}*/
		/*numerics: {{{1*/
		/*}}}*/

};
#endif  /* _TRIAVERTEXINPUT_H */
