/*! \file SolPar.h 
 *  \brief: header file for solpar object
 */

#ifndef _SOLPAR_H_
#define _SOLPAR_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
/*}}}*/

class SolPar: public Object{

	private: 
		/*no private data: this class is a container for quick access  to solution parameters, 
		 * found in the parameters dataset: */

	public:

		/*public members that need to be quickly accessed. All these members are pointers 
		 * within Param objects, so that if someone touches the Param object in the 
		 * parameters dataset, every element sees thoses changes. 
		 * */

		double& dt=NULL;

		SolPar();
		~SolPar();

		/*object derived functionality: */
		void  Echo();
		void  DeepEcho();
		int   GetId(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();

		/*functionality: */
		void  Configure(void* parameters,int analysis_type,int sub_analysis_type);
		
};
#endif  /* _SOLPAR_H */
