/*! \file BoolInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _BOOLINPUT_H_
#define _BOOLINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
#include "../include/types.h"
/*}}}*/

class BoolInput: public Input{

	private: 
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		IssmBool value;

	public:

		/*constructors, destructors: {{{1*/
		BoolInput();
		BoolInput(int enum_type,IssmBool value);
		~BoolInput();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   GetId(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();

		/*}}}*/
		/*numerics: {{{1*/
		/*}}}*/

};
#endif  /* _BOOLINPUT_H */
