/*
 * FemModel.h: 
 */

#ifndef _FEMMODEL_H_
#define _FEMMODEL_H_

/*Headers:*/
/*{{{1*/
class DataSet;
class DofVec;
#include "./Object.h"
#include "../DataSet/DataSet.h"
#include "../DataSet/Parameters.h"
#include "./DofVec.h"
#include "../toolkits/toolkits.h"
#include "../parallel/parallel.h"
/*}}}*/

class FemModel: public Object{

	/*no private members, as we need access to these datasets quite often!:*/

	public:

		DataSet*            elements;
		DataSet*            nodes;
		DataSet*            vertices;
		DataSet*            constraints;
		DataSet*            loads;
		DataSet*            materials;
		Parameters*            parameters;

		DofVec*             partition;
		DofVec*             tpartition;
		DofVec*             yg;

		Mat                 Rmg;
		NodeSets*           nodesets;
		Vec                 ys;
		Vec                 ys0;
		Mat                 Gmn;

		FemModel();
		~FemModel();
		FemModel(DataSet* elements,DataSet* nodes,DataSet* vertices, DataSet* constraints,DataSet* loads,DataSet* materials,Parameters* parameters,
			              DofVec* partition,DofVec* tpartition,DofVec* yg,Mat Rmg,Mat Gmn,NodeSets* nodesets,Vec ys,Vec ys0);
     
		/*virtual resolves: */
		void  Echo();
		void  DeepEcho();
		int   GetId();
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		
		int FindParam(double* pscalar,char* name);
		int FindParam(int* pinteger,char* name);
		int FindParam(char** pstring,char* name);
		int FindParam(char*** pstringarray,int* pM,char* name);
		int FindParam(double** pdoublearray,int* pM, int* pN,char* name);
		int FindParam(Vec* pvec,char* name);
		int FindParam(Mat* pmat,char* name);
		DataSet* get_elements(void);
		DataSet* get_nodes(void);
		DataSet* get_vertices(void);
		DataSet* get_constraints(void);
		DataSet* get_loads(void);
		DataSet* get_materials(void);
		Parameters* get_parameters(void);
		DofVec*      get_partition(void);
		DofVec*      get_tpartition(void);
		DofVec*      get_yg(void);
		Mat      get_Rmg(void);
		NodeSets* get_nodesets(void);
		Vec      get_ys(void);
		Vec      get_ys0(void);
		Mat      get_Gmn(void);

};


#endif
