/*! \file DovVec.h 
 *  \brief: header file for dofvec object
 */

#ifndef _DOFVEC_H_
#define _DOFVEC_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
#include "../toolkits/toolkits.h"

#define DOFVECNAMESIZE 20
/*}}}*/


class DofVec: public Object{
	
	public:

		char name[DOFVECNAMESIZE];
		int numdofs; //number  of dofs per entry.
		int numentries; //number of entries
		Vec vector; //vector itself.


		DofVec();
		DofVec(char* name);
		DofVec(int total_size,char* name); //default numdofs=1, numentries=total_size, default_value=0;
		DofVec(int total_size,double default_value,char* name); //default numdofs=1, numentries=total_size
		DofVec(int numdofs,int numentries,char* name);  //default_value=0;
		DofVec(int numdofs,int numentries,double default_value,char* name); 
		DofVec(double* serial_vector,int size,char* name); //default numdofs=1;
		DofVec(double* serial_vector,int numdofs,int numentries,char* name);
		DofVec(Vec vec,char* name); //default numdofs=1;
		DofVec(Vec vec,int numdofs,int numentries,char* name); 

		~DofVec();

		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		int   MyRank();
		int   Size();
	

		Object* copy();

		Vec     GetVec(void);
		void    GetVecFromDof(double** pvector,int dof);
		void    GetVecFromDof(Vec* vector,int dof);
		void    GetVecFromDofList(double** pvector, int numdofs,int* doflist);
		void    GetVecFromDofList(Vec* pvector, int numdofs,int* doflist);
		
		void    SetValuesFromVecAndDofList(double* vector,int vector_size,int numdofs,int* doflist);
		void    SetValuesFromVecAndDofList(Vec vector,int numdofs,int* doflist);
		void    SetValuesFromVecAndDofList(DofVec* vector,int numdofs,int* doflist);
		
		double* GetValuesFromIndex(int index_size,int* index);
		

};
#endif  /* _DOFVEC_H */
