/*! \file BeamVertexInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _BEAMVERTEXINPUT_H_
#define _BEAMVERTEXINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
/*}}}*/


class BeamVertexInput: public Input{

	private: 
		/*just hold 2 values for 2 vertices: */
		int    enum_type;
		double values[2];

	public:

		/*constructors, destructors: {{{1*/
		BeamVertexInput();
		BeamVertexInput(int enum_type,double* values);
		~BeamVertexInput();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   GetId(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();

		/*}}}*/
		/*numerics: {{{1*/
		/*}}}*/

};
#endif  /* _BEAMVERTEXINPUT_H */
