/*!\file Param.h
 * \brief: header file for param object
 */

#ifndef _PARAM_H_
#define _PARAM_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
#include "../toolkits/toolkits.h"
#include "../include/types.h"

#define PARAMSTRING 200 //max string length
/*}}}*/

class Param: public Object{

	private: 
		int	id; /*! id, to track it*/
		char name[PARAMSTRING]; /*! name of parameter*/
		int  type; /*! param type, from enum above*/
		
		double ddouble;
		char  string[PARAMSTRING];
		char** stringarray;
		double* doublevec;
		double* doublemat;
		Vec vec;
		Mat mat;
		int M; //dimensions of vectors and matrices
		int N;
		int ndof;

	public:

		Param();
		Param(int param_id, char* param_name, int param_type);
		~Param();

		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		char* GetParameterName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		
		void  SetDouble(double value);
		void  SetDouble(int  value);
		void  SetDoubleVec(double* value,int size);
		void  SetDoubleVec(double* value,int size,int ndof);
		void  SetDoubleMat(double* value,int M,int N);
		void  SetVec(Vec value);
		void  SetString(char* value);
		void  SetStringArray(char** value,int size);

		void  GetParameterValue(double* pdouble);
		void  GetParameterValue(int* pinteger);
		void  GetParameterValue(char** pstring);
		void  GetParameterValue(char*** pstringarray);
		void  GetParameterValue(double** pdoublearray);
		void  GetParameterValue(Vec* pvec);
		void  GetParameterValue(Mat* pmat);
		
		int   GetId(); 
		int   MyRank();
		void  DistributeNumDofs(int* numdofspernode,int analysis_type);
		int   GetType();
		int   GetM();
		int   GetN();
		int   GetNdof();
		Object* copy();

};

#endif  /* _PARAM_H_ */
