/*! \file CreateLoadsDiagnosticStokes.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../ModelProcessorx.h"

void	CreateLoadsDiagnosticStokes(DataSet** ploads, IoModel* iomodel,ConstDataHandle iomodel_handle){

	int i;
	
	DataSet*    loads    = NULL;
	Pengrid*    pengrid  = NULL;

	int segment_width;
	int element;

	/*pengrid intermediary data: */
	int numberofpressureloads;
	int counter=1;

	/*Create loads: */
	loads   = new DataSet(LoadsEnum);

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!iomodel->isstokes)goto cleanup_and_return;

	/*Create pressure loads as boundary conditions. Pay attention to the partitioning if we are running in parallel (the grids
	 * referenced by a certain load must belong to the cluster node): */
	IoModelFetchData(&iomodel->pressureload,&numberofpressureloads,NULL,iomodel_handle,"pressureload");
	IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,"elements_type");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");

	/*First load data:*/
	for (i=0;i<numberofpressureloads;i++){
		
		segment_width=6;

		element=(int)(*(iomodel->pressureload+segment_width*i+segment_width-2)-1); //element is in the penultimate column (grid1 grid2 ... elem fill)

		/*Now, if this element is not in the partition, pass: */
		if(!iomodel->my_elements[element]) continue;
	
		/*Do not create ice front if it is not a Stokes element*/
		if (!(int)*(iomodel->elements_type+2*element+1)==StokesFormulationEnum){ 
			continue;
		}

		/*Create and  add load: */
		loads->AddObject(new Icefront(i,iomodel));
		counter++;

	}
	/*Free data: */
	xfree((void**)&iomodel->pressureload);
	xfree((void**)&iomodel->elements_type);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);

	//create penalties for grids on the base of icesheet. We must have wb=ub*db/dx+vb*db/dy

	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->gridonicesheet,NULL,NULL,iomodel_handle,"gridonicesheet");
	IoModelFetchData(&iomodel->gridonstokes,NULL,NULL,iomodel_handle,"gridonstokes");
	iomodel->CreateSingleNodeToElementConnectivity;
	
	for (i=0;i<iomodel->numberofvertices;i++){
		
		if((iomodel->my_vertices[i]==1)){

			if ((iomodel->gridonbed[i]) && (iomodel->gridonicesheet[i]) && (iomodel->gridonstokes[i])){
				
				loads->AddObject(new Pengrid(counter,i,iomodel));
				counter++;
			}
		} //if((iomodel->my_vertices[i]==1))
	}

	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->gridonstokes);
	xfree((void**)&iomodel->gridonicesheet);
	xfree((void**)&iomodel->singlenodetoelementconnectivity);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	loads->Presort();

	cleanup_and_return:

	/*Assign output pointer: */
	*ploads=loads;

}
